% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationScaleDepth.R
\docType{methods}
\name{lsdGetContour}
\alias{lsdGetContour}
\alias{lsdGetContour,LSDepthContour-method}
\title{Get location-scale contour from LSDepthContour object.}
\usage{
lsdGetContour(x, cont)

\S4method{lsdGetContour}{LSDepthContour}(x, cont)
}
\arguments{
\item{x}{object of class LSDepthContour}

\item{cont}{single numeric --- depth of contour to return}
}
\description{
Get numeric values of the location-scale depth contour from existing object of LSDepthContour class.
}
\details{
Calculations are based on lsdepth algorithm written by Ch. Muller.
}
\examples{
dcont <- lsdSampleDepthContours(rf(200, 4, 7), depth = c(0.1, 0.2))

# get contour that is present in dcont object
lsdGetContour(dcont, 0.1)

# get contour that is not present in dcont
# it will be automatically calculated
lsdGetContour(dcont, 0.3)
}
