% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patt_neural.R
\name{neuralnet_response_model}
\alias{neuralnet_response_model}
\title{Modeling Responses from experimental data Using Deep NN}
\usage{
neuralnet_response_model(
  response.formula,
  exp.data,
  neuralnet.compliers,
  compl.var,
  algorithm = "rprop+",
  hidden.layer = c(4, 2),
  act.fct = "logistic",
  err.fct = "sse",
  linear.output = TRUE,
  stepmax = 1e+08
)
}
\arguments{
\item{response.formula}{formula for response variable and covariates (y ~ x)}

\item{exp.data}{\code{data.frame} of experimental data.}

\item{neuralnet.compliers}{\code{data.frame} of compliers (actual + predicted)
from \code{neuralnet_predict}.}

\item{compl.var}{string of compliance variable}

\item{algorithm}{neural network algorithm, default set to \code{"rprop+"}.}

\item{hidden.layer}{vector specifying hidden layers and number of neurons.}

\item{act.fct}{"logistic" or "tanh activation function.}

\item{err.fct}{"sse" for sum of squared errors or "ce" for cross-entropy.}

\item{linear.output}{logical for whether output (outcome variable) is linear or not.}

\item{stepmax}{maximum number of steps for training model.}
}
\value{
trained response model object
}
\description{
Model Responses from all compliers (actual + predicted)
in experimental data using neural network.
}
