% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_gdm.R
\name{run_genetic_simulation}
\alias{run_genetic_simulation}
\title{Run a high-level genetic simulation with configurable model}
\usage{
run_genetic_simulation(
  n_pops = 30,
  n_major_groups = 4,
  n_subgroups = 8,
  model = "mixed",
  geo_dims = NULL,
  isolation_factor = NULL,
  genetic_dims = NULL,
  group_separation = 15,
  subgroup_separation = NULL,
  pop_dispersion = 0.5,
  admixture_prob = 0.15,
  bottleneck_prob = 0.1,
  use_subgroups = TRUE,
  use_genetic_dims = NULL,
  use_admixture = TRUE,
  use_bottlenecks = TRUE,
  use_isolation_by_distance = NULL,
  use_nonlinear = TRUE,
  use_noise = TRUE,
  seed = NULL,
  output_file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{n_pops}{Number of populations}

\item{n_major_groups}{Number of major groups}

\item{n_subgroups}{Number of subgroups}

\item{model}{One of "mixed", "geography", "genetics", or "custom"}

\item{geo_dims}{Geographic dimensions (overrides default based on model if set)}

\item{isolation_factor}{Geography-genetics balance (overrides default based on model if set)}

\item{genetic_dims}{Genetic dimensions (overrides default based on model if set)}

\item{group_separation}{Separation between major groups}

\item{subgroup_separation}{Separation between subgroups (default: group_separation/3 when NULL)}

\item{pop_dispersion}{Within-subgroup dispersion}

\item{admixture_prob}{Proportion of admixed populations}

\item{bottleneck_prob}{Proportion of bottlenecked populations}

\item{use_subgroups}{Whether to create subgroups}

\item{use_genetic_dims}{Whether to include genetic dimensions}

\item{use_admixture}{Whether to include admixture}

\item{use_bottlenecks}{Whether to include bottlenecks}

\item{use_isolation_by_distance}{Whether to weight geographic distance}

\item{use_nonlinear}{Whether to apply nonlinear transformation}

\item{use_noise}{Whether to add noise}

\item{seed}{Optional seed forwarded to simulate_genetic_distances()}

\item{output_file}{Optional CSV file path to write the distance matrix}

\item{verbose}{Print diagnostics}
}
\value{
List with \code{results} and \code{plots} (functions to print plots)
}
\description{
Run a high-level genetic simulation with configurable model
}
