#' @keywords internal
#' @noRd
NULL

`%||%` <- function(a, b) if (!is.null(a)) a else b

#' Default bounds for lognormal mixture
#' @keywords internal
default_bounds_lognorm2 <- function(x) {
  sdy <- sd(log(x), na.rm = TRUE)
  lb <- c(0.001, log(min(x, na.rm = TRUE)) - 2, sdy/10, log(min(x, na.rm = TRUE)), sdy/10)
  ub <- c(0.999, log(max(x, na.rm = TRUE)), sdy*10, log(max(x, na.rm = TRUE)) + 2, sdy*10)
  list(lower = lb, upper = ub)
}

#' Default bounds for normal mixture
#' @keywords internal
default_bounds_norm2 <- function(x) {
  sx <- sd(x, na.rm = TRUE)
  lb <- c(0.001, min(x, na.rm = TRUE) - 2*sx, sx/10, min(x, na.rm = TRUE), sx/10)
  ub <- c(0.999, max(x, na.rm = TRUE), sx*10, max(x, na.rm = TRUE) + 2*sx, sx*10)
  list(lower = lb, upper = ub)
}

#' Reorder mixture components to prevent label switching
#' @keywords internal
order_components <- function(par) {
  p <- par[1]; mu1 <- par[2]; s1 <- par[3]; mu2 <- par[4]; s2 <- par[5]
  if (mu1 <= mu2) c(p, mu1, s1, mu2, s2) else c(1 - p, mu2, s2, mu1, s1)
}
