#' Fit 2-component lognormal mixture
#'
#' @param x numeric vector of data to fit
#' @param ... additional arguments passed to \code{\link{.fit_mix2_core}}
#' @return list with fitted parameters and metrics
#' @export
#' @importFrom DEoptim DEoptim
#' @importFrom DEoptim DEoptim.control
#' @importFrom pbapply pbsapply
fit_lognorm2 <- function(x, ...) .fit_mix2_core(x, family = "lognormal", ...)

#' Fit 2-component normal mixture
#'
#' @param x numeric vector of data to fit
#' @param ... additional arguments passed to \code{\link{.fit_mix2_core}}
#' @return list with fitted parameters and metrics
#' @export
#' @importFrom DEoptim DEoptim
#' @importFrom DEoptim DEoptim.control
#' @importFrom pbapply pbsapply
fit_norm2 <- function(x, ...) .fit_mix2_core(x, family = "normal", ...)
