% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/student_mobility_turbulence.R
\name{student_mobility_turbulence}
\alias{student_mobility_turbulence}
\title{Calculates the student mobility turbulence for a program}
\usage{
student_mobility_turbulence(
  number_withrawn,
  number_changed_major,
  total_number_of_students,
  withdrawn_coefficient = 1,
  changed_major_coefficient = 0.5
)
}
\arguments{
\item{number_withrawn}{numeric - the total number of students who dropped out of a program in a given unit}

\item{number_changed_major}{numeric - the total number of students who changed majors in a given unit}

\item{total_number_of_students}{numeric - the total number of students in a given unit starting at a specific time}

\item{withdrawn_coefficient}{numeric - a coefficient weighting the number of students who dropped out}

\item{changed_major_coefficient}{numeric - a coefficient weighting the number of students who changed majors out}
}
\value{
numeric -  The student mobility turbulence
}
\description{
This metric captures the volatility in student progression by analyzing
the withdraws and major changes, which can indicate structural barriers
or inefficiencies in the curriculum. This is most useful to apply to a combination
of programs or a unit, like a department or college. There are two coefficients,
withdrawn and changed major that can be used to prioritize either of the two causes
for turbulence. They are set to 1 and 0.5 by default, respectively.
}
