% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csp_cost_functions.R
\name{find_base_coordinates_geom}
\alias{find_base_coordinates_geom}
\title{Find stem base position using a geometric feature filtering and clustering
approach}
\usage{
find_base_coordinates_geom(
  las,
  zmin = 0.5,
  zmax = 2,
  res = 0.5,
  min_verticality = 0.9,
  min_planarity = 0.5,
  min_cluster_size = NULL
)
}
\arguments{
\item{las}{an element of lidR::LAS class}

\item{zmin}{lower search boundary}

\item{zmax}{upper search boundary}

\item{res}{cluster search radius}

\item{min_verticality}{minimum verticality >0 & <1 for a point to be
considered a stem point}

\item{min_planarity}{minimum planarity >0 & <1 for a point to be considered
a stem point}

\item{min_cluster_size}{minimum number of points in the cluster to be considered
a tree, if NULL median cluster size is chosen}
}
\value{
data.frame with X, Y, Z and TreeID for stem base positions
}
\description{
Find stem base position using a geometric feature filtering and clustering
approach
}
\examples{
# read example data
file = system.file("extdata", "beech.las", package="CspStandSegmentation")
tls = lidR::readTLSLAS(file)

# Find tree positions
map <- CspStandSegmentation::find_base_coordinates_geom(tls)
}
\author{
Julian Frey <julian.frey@wwd.uni-freiburg.de>
}
