% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_Meaco.R
\name{tidy_Meaco}
\alias{tidy_Meaco}
\title{Tidy Meaco sensor data}
\usage{
tidy_Meaco(
  mydata,
  Site_col = "RECEIVER",
  Sensor_col = "TRANSMITTER",
  Date_col = "DATE",
  Temp_col = "TEMPERATURE",
  RH_col = "HUMIDITY"
)
}
\arguments{
\item{mydata}{A data frame containing raw Meaco sensor data with columns
RECEIVER, TRANSMITTER, DATE, TEMPERATURE, and HUMIDITY}

\item{Site_col}{A string specifying the name of the column in `mydata` that contains
location information. Default is "RECEIVER".}

\item{Sensor_col}{A string specifying the name of the column in `mydata` that contains
sensor information. Default is "TRANSMITTER".}

\item{Date_col}{A string specifying the name of the column in `mydata` that contains
date information. Default is "DATE".}

\item{Temp_col}{A string specifying the name of the column in `mydata` that contains
temperature data. Default is "TEMPERATURE".}

\item{RH_col}{A string specifying the name of the column in `mydata` that contains
relative humidity data. Default is "HUMIDITY".}
}
\value{
A tidied data frame with columns Site, Sensor, Date, Temp, and RH
}
\description{
This function takes raw Meaco sensor data and returns data with renamed columns.
}
\examples{

\donttest{
# Example usage: meaco_data <- tidy_Meaco("path/to/your/meaco_data.csv")
}

# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "Meaco")

head(mydata)

mydata |> tidy_Meaco()

mydata |> tidy_Meaco() |> tidy_TRHdata(avg_time = "hour")



}
