% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMR.R
\name{calcMR}
\alias{calcMR}
\title{Calculate Mixing Ratio}
\usage{
calcMR(Temp, RH, P_atm = 1013.25, B = 621.9907, ...)
}
\arguments{
\item{Temp}{Temperature (°Celsius)}

\item{RH}{Relative Humidity (0-100\%)}

\item{P_atm}{Atmospheric pressure = 1013.25 (hPa)}

\item{B}{B = 621.9907 g/kg for air}

\item{...}{Additional arguments to supply to \code{\link{calcPws}}}
}
\value{
X Mixing ratio, mass of water vapour / mass of dry gas (g/kg)
}
\description{
Function to calculate mixing ratio (g/kg) from temperature (°C) and relative humidity (\%).

Mixing Ratio is the mass of water vapor present in a given volume of air relative to the mass of dry air.
}
\details{
X Mixing ratio (mass of water vapour / mass of dry gas)

Pw = Pws(40°C) = 73.75 hPa

X = 621.9907 x 73.75 / (998 - 73.75) = 49.63 g/kg
}
\examples{
# Mixing ratio at 20°C (Temp) and 50\% relative humidity (RH)
calcMR(20, 50)

# mydata file
filepath <- data_file_path("mydata.xlsx")
mydata <- readxl::read_excel(filepath, sheet = "mydata", n_max = 5)

mydata |> dplyr::mutate(MixingRatio = calcMR(Temp, RH))


}
\seealso{
\code{\link{calcMR}} for calculating mixing ratio

\code{\link{calcAD}} for calculating air density

\code{\link{calcPw}} for calculating water vapour pressure

\code{\link{calcPws}} for calculating water vapour saturation pressure
}
