% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetCohorts.R
\name{subsetCohorts}
\alias{subsetCohorts}
\title{Generate a cohort table keeping a subset of cohorts.}
\usage{
subsetCohorts(cohort, cohortId, name = tableName(cohort))
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector identifying which cohorts to include
(cohort_definition_id or cohort_name). Cohorts not included will be
removed from the cohort set.}

\item{name}{Name of the new cohort table created in the cdm object.}
}
\value{
Cohort table with only cohorts in cohortId.
}
\description{
\code{subsetCohorts()} filters an existing cohort table, keeping only the records
from cohorts that are specified.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()

cdm$cohort1 |>
  subsetCohorts(cohortId = 1)
}
}
