% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sleep_metrics.R
\name{extract_sleep_metrics}
\alias{extract_sleep_metrics}
\title{Extract metrics related to sleep and circadian rhythm after using CircaCP algorithm}
\usage{
extract_sleep_metrics(df, min_sleep_episode_min = 180L)
}
\arguments{
\item{df}{\code{data.frame} with columns \code{id}, \code{Date}, \code{Time}, \code{Activity}, \code{label.sw}.}

\item{min_sleep_episode_min}{Minimum duration (minutes) to treat as a main sleep episode.}
}
\value{
A \code{data.frame} with columns including:
\describe{
\item{id}{Subject ID obtained from the stem of filename.}
\item{period_type}{sleep or wake}
\item{timestamp}{datetime of sleep onset time and wake onset time}
\item{clock_min}{timestamps presented as minutes of the day since midnight}
\item{duration_hours}{sleep duration or wake duration}
\item{SleepTimeSD_hours}{Standard devation of sleep onset time (calculated by circular statistics)}
\item{WakeTimeSD_hours}{Standard devation of sleep onset time (calculated by circular statistics)}
\item{SRI}{Sleep regularity index}
\item{Mesor, Amplitude, Acrophase}{parameters obtained from the cosinor model}
\item{RA, IS, IV, L5_mean, L5_start_min, M10_mean, M10_start_min}{nonparametrics actigraphy metrics}
}
}
\description{
From minute-level data with sleep/wake labels (\code{label.sw} 1 = sleep, 0 = wake),
extracts sleep/wake onsets, episode durations, circular SDs of onset times,
Sleep Regularity Index (SRI), cosinor parameters, day/night variance ratio,
and nonparametric metrics (RA, IS, IV, L5, M10). Returns one row per episode
with scalar metrics repeated per row (tidy format).
}
\seealso{
\code{\link[=sleep_detection]{sleep_detection()}}, \code{\link[=sleep_cos]{sleep_cos()}}, \code{\link[=extract_nonparametric_metrics]{extract_nonparametric_metrics()}}
}
