% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_nonparametric_metrics.R
\name{extract_nonparametric_metrics}
\alias{extract_nonparametric_metrics}
\title{Nonparametric circadian metrics (RA, IS, IV, L5, M10)}
\usage{
extract_nonparametric_metrics(df, L_window = 5 * 60, M_window = 10 * 60)
}
\arguments{
\item{df}{cleaned data frame containing the activity varialbe at 1-minute epoch}

\item{L_window}{Integer window length (minutes) for L5 (default 300).}

\item{M_window}{Integer window length (minutes) for M10 (default 600).}
}
\value{
A list with components:
\describe{
\item{RA}{Relative amplitude, \eqn{(M10 - L5) / (M10 + L5)} when denominator \eqn{> 0}.}
\item{IS}{Interdaily stability (0..1).}
\item{IV}{Intradaily variability (\eqn{\ge 0}).}
\item{L5_mean}{Mean activity in the lowest 5-hour block of the 24 h profile.}
\item{L5_start_min}{Minute-of-day (0~1439) at which L5 starts.}
\item{M10_mean}{Mean activity in the highest 10-hour block of the 24 h profile.}
\item{M10_start_min}{Minute-of-day (0~1439) at which M10 starts.}
\item{profile_24h}{Length-1440 vector of minute-of-day means.}
}
}
\description{
Computes five nonparametric metrics from minute-level activity:
Relative Amplitude (RA), Interdaily Stability (IS),
Intradaily Variability (IV), the least-active 5-hour block (L5),
and the most-active 10-hour block (M10).
}
\seealso{
\code{\link[=screen_wear]{screen_wear()}}, \code{\link[=sleep_detection]{sleep_detection()}}, \link{extract_sleep_metrics}
}
