#' CircaCP: Actigraphy Import, Screening, and Circadian Metrics
#'
#' @description
#' Tools to import actigraphy files, screen/clean wear, detect sleep,
#' and compute cosinor + nonparametric circadian metrics.
#'
#' @section Quick start:
#' \preformatted{
#' df <- import_acti_file(file, date_col="Date", time_col="Time", activity_cols="Activity")
#' scr <- screen_wear(df, min_days=5, max_zero_run=200)
#' if (scr$status == "ok") {
#'   newdf   <- sleep_detection(scr$clean_df, thr=0.4, dist="ZAG")
#'   metrics <- extract_sleep_metrics_df(newdf)
#' }
#' }
#'
#' @section Key functions:
#' \itemize{
#'   \item \code{import_acti_file()} — import with header stripping
#'   \item \code{screen_wear()} — decimate + longest-wear screening
#'   \item \code{sleep_cos()} — fit cosinor model + circadian windowing
#'   \item \code{sleep_detection()} — cosinor + threshold labeling
#'   \item \code{extract_nonparametric_metrics()} — RA/IS/IV/L5/M10
#'   \item \code{extract_sleep_metrics()} — tidy per-episode metrics
#' }
#'
#' @keywords internal
"_PACKAGE"
