% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_PMLParametersSet.R
\name{create_ModelPK}
\alias{create_ModelPK}
\alias{get_PMLParametersSets}
\title{Get the list of objects describing the PML models by set of PK parameters}
\usage{
create_ModelPK(
  CompartmentsNumber = 1,
  Absorption = "Intravenous",
  Parameterization = "Clearance",
  Saturation = FALSE,
  EliminationCpt = FALSE,
  FractionExcreted = FALSE,
  ByVector = FALSE,
  ClosedForm = TRUE,
  ...
)

get_PMLParametersSets(
  CompartmentsNumber = 1,
  Absorption = "Intravenous",
  Parameterization = "Clearance",
  Saturation = FALSE,
  EliminationCpt = FALSE,
  FractionExcreted = FALSE,
  ByVector = FALSE,
  ClosedForm = TRUE,
  ...
)
}
\arguments{
\item{CompartmentsNumber}{The number of compartments in the model. Supported
embedded models are 1-, 2-, 3-compartments. Default is 1.}

\item{Absorption}{The absorption type of the model. Supported types are:
\itemize{
\item \code{Intravenous} (Default) - Dose is given in the main compartment (A1) directly.
\item \code{First-Order} - Dose is absorbed to the main compartment (A1) from the
absorption compartment (Aa) by first-order kinetic.
\item \code{Gamma} - Dose is absorbed to A1 by Gamma Distributed delay kinetic.
\item \verb{Inverse Gaussian} - Dose is absorbed to A1 by Inverse Gaussian Distributed delay kinetic.
\item \code{Weibull} - Dose is absorbed to A1 by Weibull Distributed delay kinetic.
}}

\item{Parameterization}{The parameterization type. Possible options are
\code{Clearance} - Clearance parameters: Cl, Cl2 to be used and \code{Micro} - Micro
parameters: Ke, K12, K21 to be used. Default is \code{Clearance}.}

\item{Saturation}{Logical indicating whether saturation should be considered.
Default is \code{FALSE}.}

\item{EliminationCpt}{Logical indicating whether elimination compartment
should be included. Default is \code{FALSE}.}

\item{FractionExcreted}{Logical indicating whether fraction excreted
structural parameter should be included in urinecpt statement: \code{urinecpt(A0 = Cl * C, fe=Fe)}. Valid only if \code{EliminationCpt == TRUE}. Default is
\code{FALSE}.}

\item{ByVector}{Logical indicating whether each element in vectorized
argument should be treated as a separate PML structure (i.e. treated as
data.frame vectors), \code{TRUE}, or as parameters to obtain a pool (i.e.
expanded) of PML structures, \code{FALSE}. Default is \code{FALSE} (one value for a
function call).}

\item{ClosedForm}{Logical indicating whether closed forms (cfMicro) should be
used when possible. Note that closed forms are not available for the models
with elimination compartment, models with saturation or absorption types
other than \code{Intravenous} or \code{First-Order}. The models with interpolated
covariates must use \code{ClosedForm == FALSE}. Default is \code{TRUE} (one value for
a function call).}

\item{...}{Additional named arguments, including Structural parameters
(StParm), Covariates, Dosepoints (for PK models), Thetas and Omegas. See
'Additional arguments' section.}
}
\value{
A list of PML models (\code{PMLModels} class instance) matching the
specified options.
}
\description{
This function provides the PML (Pharmacometric Modelling Language) PK
parameter sets based on the specified options. They are available as a list
of specific S3 classes.
}
\details{
The names of \code{PMLStructure} are constructed
by the following parts:
\itemize{
\item Model type ('PK'),
\item Compartments number
\item Abbreviated absorption type:
\itemize{
\item 'IV' for Intravenous,
\item 'FO' for First-Order,
\item 'G' for Gamma,
\item 'W' for Weibull,
\item 'IG' for Inverse Gaussian,
}
\item Abbreviated parameterization ('C' for Clearance and 'M' for Micro),
\item Abbreviated saturation if presented ('S'),
\item Abbreviated elimination if presented ('E'),
\item Abbreviated fraction excreted if presented ('F').
}
}
\section{Additional arguments}{
Additional arguments (ellipsis) will be applied
sequentially. They can be used to add or modify Structural parameters
(StParm), Covariates, Observations, Dosepoints (for PK models); by the way it is advised to
use specific functions for it (see 'See Also' section for the references).
Also it is possible to modify Omegas and Thetas, but it is impossible to add
them (they are parts of other structures). If \code{PMLStructure} argument is not
specified, class instances will be modified or added in all PML structures.
If \code{PMLStructure} argument is specified, class instances in the specified PML
structure will be modified/added. Note that only one PML structure could be
added to the class instance. If multiple structures should be modified,
suggest to use specific functions.
}

\examples{
# Get PK model set with default options
PMLParametersSets <- create_ModelPK()

#' # Get PK Model search with custom options:
# will create 2 PML Parameters Sets with 2 and 3 compartments,
# with Absorption First-Order and Gamma accordingly:
ModelPKSearch <-
  create_ModelPK(CompartmentsNumber = c(2, 3),
                 Parameterization = "Micro",
                 Absorption = c("First-Order", "Gamma"),
                 ByVector = TRUE,
                 ClosedForm = TRUE)


# Next example will create a set of 4 PMLParametersSets:
# a combination of models with 2 and 3 compartments and First-Order and Gamma Absorption
PMLParametersSets <-
  create_ModelPK(CompartmentsNumber = c(2, 3),
                 Absorption = c("First-Order", "Gamma"),
                 ByVector = FALSE,
                 ClosedForm = FALSE)

# Create 2 PML Parameters Sets with elimination compartment and fraction excreted
# and add zero order absorption to the main dosepoint of the PML Structure
# with infusion
PMLParametersSets <-
  create_ModelPK(CompartmentsNumber = 1,
                 Absorption = c("Intravenous", "Gamma"),
                 EliminationCpt = TRUE,
                 FractionExcreted = TRUE,
                 duration = StParm(StParmName = "Duration",
                                   OmegaStParm = Omega(State = "None")),
                                   PMLStructure = "PK1IVCEF")

# Create 4 PML Parameters Sets, then modify `Cl` structural parameter for all sets,
# with 2 initial estimates sets to be searched,
# add `tlag` as a structural parameter `Tlag` to 1 compartment First-Order PML parameters set,
# change `tvKa` Theta initial estimate,
# change `nV` Omega initial estimate,
# change `CObs` Observation sigmas,
# add structural parameter `Rate` for 1 compartment Weibull Parameters set,
# add `Weight` covariate for all structural parameters to be searched.

PMLParametersSets <-
   create_ModelPK(
     CompartmentsNumber = 1,
     Absorption = c("First-Order", "Weibull"),
     ByVector = FALSE,
     Cl = StParm(
       StParmName = "Cl",
       Type = "LogNormal2",
       ThetaStParm =
         Theta(Name = "tvCl",
               InitialEstimates =
                 InitialEstimate(c(-Inf, 0.2, Inf),
                                 c(0, 3, 10)))
     ),
     tlag = StParm(
       StParmName = "Tlag",
       State = "Searched",
       PMLStructure = "PK1FOC",
       Covariates = list(
         Age = Covariate(
           Name = "Age",
           Type = "Categorical",
           State = "Searched",
           Direction = "Backward",
           Center = "None",
           Categories = c(1, 2, 3)
         )
       )
     ),
     tvKa = Theta(Name = "tvKa", InitialEstimates = 10),
     nV = Omega(Name = "nV", InitialOmega = 0.1),
     CObs = Observation(
       ObservationName = "CObs",
       SigmasChosen = list(
         AdditiveMultiplicative = c(PropPart = 0.1, AddPart = 2),
         Proportional = 1
       )
     ),
     A1 = Dosepoint(
       DosepointName = "A1",
       rate = StParm(StParmName = "Rate"),
       PMLStructure = "PK1WC"
     ),
     Weight = Covariate(
       Name = "Weight",
       State = "Searched",
       Center = "Median"
     )
   )

}
\seealso{
Functions used for Dosepoint specification: 
\code{\link{Dosepoint}()},
\code{\link{add_Dosepoint}()},
\code{\link{modify_Dosepoint}()}

Functions used for StParm specification: 
\code{\link{StParm}()},
\code{\link{add_StParm}()},
\code{\link{create_ModelPD}()},
\code{\link{modify_StParm}()},
\code{\link{modify_StParmCustom}()},
\code{\link{remove_StParm}()}

Functions used for Observation specification: 
\code{\link{Observation}()},
\code{\link{ObservationCustom}()},
\code{\link{Sigmas}()},
\code{\link{create_ModelPD}()},
\code{\link{modify_Observation}()},
\code{\link{remove_Observation}()}

Functions used for Omega specification: 
\code{\link{Omega}()},
\code{\link{create_ModelPD}()},
\code{\link{modify_Omega}()}

Functions used for Theta specification: 
\code{\link{InitialEstimate}()},
\code{\link{Theta}()},
\code{\link{create_ModelPD}()},
\code{\link{modify_Theta}()}

Functions used for Covariate specification: 
\code{\link{Covariate}()},
\code{\link{add_Covariate}()},
\code{\link{create_ModelPD}()},
\code{\link{remove_Covariate}()}
}
\concept{Covariates}
\concept{Dosepoints}
\concept{Observations}
\concept{Omegas}
\concept{StParms}
\concept{Thetas}
