% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_SMSNcentered.R
\name{CensRegSMSN}
\alias{CensRegSMSN}
\title{Fit Censored Linear Regression Model under Scale Mixtures of Skew-Normal Distributions}
\usage{
CensRegSMSN(
  cc,
  x,
  y,
  beta = NULL,
  sigma2 = NULL,
  lambda = NULL,
  nu = NULL,
  cens = "Int",
  UL = NULL,
  get.init = TRUE,
  show.envelope = FALSE,
  error = 1e-04,
  iter.max = 300,
  family = "ST",
  verbose = TRUE
)
}
\arguments{
\item{cc}{Indicator vector for incomplete observations of length \code{n}. Each element should be \code{0} if the observation is fully observed, or \code{1} if it is incomplete (either censored or missing).}

\item{x}{Design matrix (of dimension \code{n x p}) corresponding to the covariates in the linear predictor.}

\item{y}{Response vector of length \code{n}. For fully observed data, it contains the observed values. In the case of right or left censoring, it represents the censoring limit. For interval censoring, it corresponds to the lower bound of the censoring interval. Missing values (\code{NA}) are allowed.}

\item{beta}{Optional initial values for the regression coefficients. Default is \code{NULL}.}

\item{sigma2}{Optional initial value for the scale parameter. Default is \code{NULL}.}

\item{lambda}{Optional initial value for the shape parameter (for skewed distributions). Default is \code{NULL}.}

\item{nu}{Optional initial value for the distribution-specific parameter. Required for \code{T}, \code{ST}, \code{CN}, and \code{SCN} families. Must be a two-dimensional vector for \code{CN} and \code{SCN}. Should not be provided for \code{N} or \code{SN}. Default is \code{NULL}.}

\item{cens}{Character indicating the type of censoring. Should be one of \code{"Left"}, \code{"Right"} or \code{"Int"}. Default is \code{"Int"}.}

\item{UL}{Vector of upper limits of length \code{n} for interval-censored observations. Must be provided when \code{cens = "Int"}.}

\item{get.init}{Logical; if \code{TRUE}, initial values are automatically computed. If \code{FALSE}, initial values must be provided. Default is \code{TRUE}.}

\item{show.envelope}{Logical; if \code{TRUE}, an envelope plot based on transformed martingale residuals is produced. Default is \code{FALSE}.}

\item{error}{Convergence threshold for the algorithm. Default is \code{0.0001}.}

\item{iter.max}{Maximum number of iterations allowed in the algorithm. Default is \code{300}.}

\item{family}{Character string indicating the distribution family. Possible values include: \code{"SN"} (Skew-Normal), \code{"ST"} (Skew-t), \code{"SCN"} (Skew Contaminated Normal), \code{"N"} (Normal), \code{"T"} (Student-t), \code{"CN"} (Contaminated Normal). Default is \code{"ST"}.}

\item{verbose}{Logical indicating whether results should be printed to the console. Default is \code{TRUE}.}
}
\value{
A list with the following components:
\item{beta}{Estimated regression coefficients.}
\item{sigma2}{Estimated scale parameter.}
\item{lambda}{Estimated shape parameter. For symmetric distributions ("N", "T", "CN"), this is zero.}
\item{nu}{Estimated parameters of the scale mixture distribution. \code{NULL} for "SN" and "N" families. A scalar for "ST" and "T", and a vector for "SCN" and "CN".}
\item{SE}{Standard errors of the estimated parameters.}
\item{iter}{Number of iterations until convergence.}
\item{logver}{Value of the log-likelihood function at convergence, computed under the fitted model.}
\item{AIC, BIC, CAIC, HQ}{Information criteria for model selection.}
\item{residual}{Transformed martingale residuals used for envelope plots. Returned only if \code{show.envelope = TRUE}; otherwise \code{NULL}.}
}
\description{
Fits a univariate linear regression model with censoring and/or missing values in the response variable, assuming it follows a distribution from the Scale Mixtures of Skew-Normal (SMSN) family. Computes standard errors using the empirical information matrix and provides model selection criteria (AIC, BIC, CAIC, HQ). Optionally generates envelope plots based on martingale residuals.
}
\details{
The model assumes that the response variable follows a distribution from the Scale Mixtures of Skew-Normal (SMSN) family, which allows for heavy tails and/or asymmetry.

Interval censoring is a general framework that includes left and right censoring and missing responses, providing a unified treatment for all cases.

For the Skew Contaminated Normal (\code{"SCN"}) and the Contaminated Normal (\code{"CN"}) distributions, the \code{nu} parameter must be a two-dimensional vector with values in the interval \eqn{(0, 1)}.
}
\examples{
# See examples in ?gen_SMSNCens_sample  for a complete workflow
# illustrating data generation and model fitting.

}
\references{
Gil, Y. A., Garay, A. M. & Lachos, V. H.
Likelihood-based inference for interval censored regression models under heavy-tailed distributions.
\emph{Stat Methods Appl} 34, 519–544 (2025). \doi{10.1007/s10260-025-00797-x}.
}
