% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_taxa.R
\name{qc_taxa}
\alias{qc_taxa}
\title{Quality Control Check on User Data Against Master Taxa List}
\usage{
qc_taxa(
  DF_User,
  DF_Official = NULL,
  fun.Community = NULL,
  useOfficialTaxaInfo = "only_Official"
)
}
\arguments{
\item{DF_User}{User taxa data.}

\item{DF_Official}{Official master taxa list.  Can be a local file or
from a URL.
Default is NULL.  A NULL value will use the official online files.}

\item{fun.Community}{Community name for which to compare the master taxa list
(bugs or fish).}

\item{useOfficialTaxaInfo}{Select how to handle new/different taxa.
See 'Details' for more information.
Valid values are "only_Official", "only_user", "add_new".
Default = "only_Official".}
}
\value{
input data frame with master taxa information added to it.
}
\description{
This function compares the user's data frame to a data frame with the
official (or user supplied) master taxa list (benthic macroinvertebrates).
}
\details{
Output is a data frame with matches.

Messages are output to the console with the number of matches and which user
taxa did not match the official list.

The official list is stored online but the user can input their own saved
copy.

Any columns in the user input file that match the official master taxa list
will be renamed with the "_NonOfficial" suffix.

New/different taxa in the user data are handled by the 'useOfficialTaxaInfo'
parameter.  For taxa that did not match the master taxa list the user has
options on how to handle the differences for the phylogeny (e.g., columns for
phylum, class, family, etc.) and autecology (e.g., columns for FFG, habit,
tolerance value, etc.).  The options are below.

* only_official = use only official master taxa information.  Any
non-matching taxa will not have any master taxa information.

* only_user = only use the information provided by the user.  Information
from the 'Official' will not be used.  This should only be used for
non-official calculations.

* add_new = hybrid approach that uses official master taxa information, when
present, but includes user information for non-matching taxa if the column
names match.

Default master taxa lists are saved as CSV files online at:

https://github.com/leppott/MBSStools_SupportFiles

The files can be downloaded with the following code.

**Benthic Macroinvertebrate**

url_mt_bugs <- "https://github.com/leppott/MBSStools_SupportFiles/raw/master/Data/CHAR_Bugs.csv"
df_mt_bugs <- read.csv(url_mt_bugs)

The master taxa files are periodically updated.  Update dates will be logged
on the GitHub repository.

Expected fields include:

**Benthic Macroinvertebrates**

    + TAXON, Phylum, Class, Order, Family, Genus, Other_Taxa, Tribe, FFG,
      FAM_TV, Habit, FinalTolVal07, Comment
}
\examples{
# Example 1, Master Taxa List, Bugs
url_mt_bugs <- "https://github.com/leppott/MBSStools_SupportFiles/raw/master/Data/CHAR_Bugs.csv"
df_mt_bugs  <- read.csv(url_mt_bugs)

# User data
DF_User <- data_benthos_MBSS
DF_Official <- NULL   # NULL df_mt_bugs
fun.Community <- "bugs"
useOfficialTaxaInfo <- "only_Official"
# modify taxa id column
DF_User[, "TAXON"] <- DF_User[, "TAXAID"]

df_qc_taxa_bugs <- qc_taxa(DF_User,
                           DF_Official,
                           fun.Community,
                           useOfficialTaxaInfo)

# QC input/output
dim(DF_User)
dim(df_qc_taxa_bugs)
names(DF_User)
names(df_qc_taxa_bugs)
}
