% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_checks.R
\name{qc.checks}
\alias{qc.checks}
\title{QC checks on metric values}
\usage{
qc.checks(df.metrics, df.checks, input.shape = "wide")
}
\arguments{
\item{df.metrics}{Wide data frame with metric values to be evaluated.}

\item{df.checks}{Data frame of metric thresholds to check.}

\item{input.shape}{Shape of df.metrics; wide or long.  Default is wide.}
}
\value{
Returns a data frame of SampleID checks and results; Pass and Fail.
}
\description{
Apply "QC checks" on calculated metrics and station/sample
attributes to "flag" samples for the user. Examples include watershed size or
 total number of individuals.  Can have checks for both high and low values.
Checks are stored in separate file.  For structure see df.checks in example.
}
\details{
used reshape2 package
}
\examples{
library(readxl)

# Calculate Metrics
df.samps.bugs <- read_excel(system.file("./extdata/Data_Benthos.xlsx",
                                        package="BioMonTools"),
                            guess_max = 10^6)

# Columns to keep
myCols <- c("Area_mi2", "SurfaceArea", "Density_m2", "Density_ft2")

# Run Function
myDF <- df.samps.bugs
df.metric.values.bugs <- metric.values(myDF, "bugs", fun.cols2keep = myCols)

# Import Checks
df.checks <- read_excel(system.file("./extdata/MetricFlags.xlsx",
                                    package="BioMonTools"),
                        sheet="Flags")

# Run Function
df.flags <- qc.checks(df.metric.values.bugs, df.checks)

# Summarize Results
table(df.flags[, "CHECKNAME"], df.flags[, "FLAG"], useNA = "ifany")
}
