% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BF10.cor}
\alias{BF10.cor}
\title{Bayes factor for a Bayesian correlation test}
\usage{
BF10.cor(
  r,
  n,
  k,
  alpha,
  beta,
  h0,
  hypothesis,
  location,
  scale,
  dff,
  model,
  e = NULL
)
}
\arguments{
\item{r}{Observed correlation coefficient.}

\item{n}{Sample size.}

\item{k}{Parameter for the analysis default beta prior under the alternative hypothesis.}

\item{alpha}{Parameter for the analysis beta prior under the alternative hypothesis.}

\item{beta}{Parameter for the analysis beta prior under the alternative hypothesis.}

\item{h0}{Null value of the correlation.}

\item{hypothesis}{The hypothesis being tested: two-sided (\code{"!="}), right-sided (\code{">"}), or left-sided (\code{"<"}).}

\item{location}{Location parameter for the analysis prior under the alternative hypothesis.}

\item{scale}{Scale parameter for the analysis normal moment prior under the alternative hypothesis.}

\item{dff}{Degrees of freedom for the analysis prior under the alternative hypothesis (if applicable).}

\item{model}{Statistical model of the analysis prior under the alternative hypothesis: default beta (\code{"d_beta"}), beta (\code{"beta"}), or normal moment (\code{"NLP"}).}

\item{e}{Optional numeric vector specifying bounds for an interval null; used if interval BF is calculated.}
}
\value{
The Bayes factor (BF10) for the correlation test.
}
\description{
Calculate the Bayes factor (BF10) for a correlation, either against a point null or an interval null hypothesis.
}
\examples{
BF10.cor(
  r = 0.3,
  n = 50,
  k = 1,
  alpha = 0.05,
  beta = 0.2,
  h0 = 0,
  hypothesis = "!=",
  location = 0,
  scale = 1,
  dff = 49,
  model = "d_beta"
)
}
