% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{orderCoordinatesMMD}
\alias{orderCoordinatesMMD}
\title{Order coordinates according to a maximum-minimum distance criterion.}
\usage{
orderCoordinatesMMD(coords, exact = FALSE)
}
\arguments{
\item{coords}{N x 2 array of N 2-dimensional (x,y) spatial coordinates.}

\item{exact}{Logical; \code{FALSE} uses a fast approximation to MMD ordering
(and is almost always recommended), while \code{TRUE} uses exact MMD
ordering but is infeasible for large number of locations.}
}
\value{
A list of distances matrices, with the following components:
\item{orderedCoords}{N x 2 matrix; contains the ordered spatial coordinates
as \code{coords}.}
\item{orderedIndicesNoNA}{N-vector; contains the ordered indices with any
NA values removed.}
}
\description{
\code{orderCoordinatesMMD} orders an array of (x,y) spatial coordinates
according to the "maximum minimum distance" (MMD), as described in Guinness,
2018. (Points are selected to maximize their minimum distance to already-
selected points).
}
\examples{
coords <- cbind(runif(100), runif(100))
orderCoordinatesMMD(coords)

}
