% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{nsCrosscorr}
\alias{nsCrosscorr}
\title{Calculate a nonstationary Matern cross-correlation matrix}
\usage{
nsCrosscorr(
  Xdist1_sq,
  Xdist2_sq,
  Xdist12,
  Sigma11,
  Sigma22,
  Sigma12,
  PSigma11,
  PSigma22,
  PSigma12,
  nu,
  d
)
}
\arguments{
\item{Xdist1_sq}{M x N matrix; contains values of pairwise squared cross-distances
in the x-coordinate.}

\item{Xdist2_sq}{M x N matrix; contains values of pairwise squared cross-distances
in the y-coordinate.}

\item{Xdist12}{M x N matrix; contains values of pairwise signed cross/cross-
distances between the x- and y-coordinates. The sign of each element is
important; see \code{nsDist} function for the details of this calculation.
in the x-coordinate.}

\item{Sigma11}{Vector of length N; contains the 1-1 element of the
anisotropy process for each observed location.}

\item{Sigma22}{Vector of length N; contains the 2-2 element of the
anisotropy process for each observed location.}

\item{Sigma12}{Vector of length N; contains the 1-2 element of the
anisotropy process for each observed location.}

\item{PSigma11}{Vector of length N; contains the 1-1 element of the
anisotropy process for each prediction location.}

\item{PSigma22}{Vector of length N; contains the 2-2 element of the
anisotropy process for each prediction location.}

\item{PSigma12}{Vector of length N; contains the 1-2 element of the
anisotropy process for each prediction location.}

\item{nu}{Scalar; Matern smoothness parameter. \code{nu = 0.5} corresponds
to the Exponential correlation; \code{nu = Inf} corresponds to the Gaussian
correlation function.}

\item{d}{Scalar; dimension of the spatial domain.}
}
\value{
A M x N cross-correlation matrix for two fixed sets of stations and
fixed parameter values.
}
\description{
\code{nsCrosscorr} calculates a nonstationary cross-correlation matrix
between two fixed sets of locations (a prediction set with M locations, and
the observed set with N locations), based on vectors of the unique anisotropy
parameters for each station. Since the correlation function uses a
spatially-varying Mahalanobis distance, this function requires coordinate-
specific distance matrices (see below). The function is coded as a
\code{nimbleFunction} (see the \code{nimble} package) but can also be
used as a regular R function.
}
\examples{
# Generate some coordinates and parameters
coords <- cbind(runif(100),runif(100))
Sigma11 <- rep(1, 100) # Identity anisotropy process
Sigma22 <- rep(1, 100)
Sigma12 <- rep(0, 100)
Pcoords <- cbind(runif(200),runif(200))
PSigma11 <- rep(1, 200) # Identity anisotropy process
PSigma22 <- rep(1, 200)
PSigma12 <- rep(0, 200)
nu <- 2
# Calculate distances
Xdist_list <- nsCrossdist(coords, Pcoords)
# Calculate the correlation matrix
XcorMat <- nsCrosscorr(Xdist_list$dist1_sq, Xdist_list$dist2_sq, Xdist_list$dist12,
   Sigma11, Sigma22, Sigma12, PSigma11, PSigma22, PSigma12, nu, ncol(coords))

}
