% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/read.R
\docType{methods}
\name{read_bcal}
\alias{read_bcal}
\alias{read_bcal-method}
\alias{read_bcal,character-method}
\title{Read BCal Output}
\usage{
read_bcal(file, ...)

\S4method{read_bcal}{character}(file, bin_width = 1, calendar = BP())
}
\arguments{
\item{file}{A \code{\link{character}} string giving the name of the CSV file which the
data are to be read from.}

\item{...}{Currently not used.}

\item{bin_width}{The bin width specified for the
\href{https://bcal.shef.ac.uk/}{BCal} calibration. Defaults to the BCal
default of 1.}

\item{calendar}{A \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the calendar
(see \code{\link[aion:calendar]{aion::calendar()}}). It should be \code{\link[aion:gregorian]{aion::BP()}} unless you change the
default settings in 'BCal'.}
}
\value{
An \code{\linkS4class{EventsMCMC}} object.
}
\description{
Reads MCMC output.
}
\examples{
if (requireNamespace("ArchaeoData", quietly = TRUE)) {
  ## Construct the path to the data
  path_output <- system.file("bcal", "fishpond.csv", package = "ArchaeoData")

  ## Import BCal Output
  (bcal <- read_bcal(path_output))
}
}
\references{
Buck C. E., Christen J. A. & James G. N. (1999). BCal: an on-line Bayesian
radiocarbon calibration tool. \emph{Internet Archaeology}, 7.
\doi{10.11141/ia.7.1}.
}
\seealso{
\code{\link[utils:read.table]{utils::read.table()}}

Other read methods: 
\code{\link{as_coda}()},
\code{\link{as_events}()},
\code{\link{as_phases}()},
\code{\link{check}},
\code{\link{read_chronomodel}},
\code{\link{read_oxcal}()}
}
\author{
T. S. Dye, N. Frerebeau
}
\concept{read methods}
