/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.SplitUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitSystem {
    private int labelCount;
    private int splitCount;
    private List<Taxon> taxa;
    private boolean[][] splits;

    public SplitSystem(Collection<Taxon> taxa, int size) {
        this.taxa = Collections.unmodifiableList(new ArrayList<Taxon>(taxa));
        this.labelCount = taxa.size();
        this.splitCount = size;
        this.splits = new boolean[this.splitCount][this.labelCount];
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public boolean[][] getSplitVector() {
        return this.splits;
    }

    public boolean[] getSplit(int i) {
        return this.splits[i];
    }

    public List<Taxon> getTaxa() {
        return this.taxa;
    }

    public boolean hasSplit(boolean[] split) {
        for (int i = 0; i < this.splitCount; ++i) {
            if (!SplitUtils.isSame(split, this.splits[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (i = 0; i < this.labelCount; ++i) {
            pw.println(this.taxa.get(i));
        }
        pw.println();
        for (i = 0; i < this.splitCount; ++i) {
            for (int j = 0; j < this.labelCount; ++j) {
                if (this.splits[i][j]) {
                    pw.print('*');
                    continue;
                }
                pw.print('.');
            }
            pw.println();
        }
        return sw.toString();
    }
}

