/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;

public class MarginalizedAlphaStableDistribution
implements Distribution {
    private final double scale;
    private final double alpha;

    public MarginalizedAlphaStableDistribution(double d, double d2) {
        this.scale = d;
        this.alpha = d2;
    }

    @Override
    public double pdf(double d) {
        return Math.exp(this.logPdf(d));
    }

    @Override
    public double logPdf(double d) {
        return MarginalizedAlphaStableDistribution.logPdf(d, this.scale, this.alpha);
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented");
    }

    public static double logPdf(double d, double d2, double d3) {
        return -Math.log(d2) - Math.pow(Math.abs(d) / d2, d3);
    }

    public static double gradLogPdf(double d, double d2, double d3) {
        return -d3 * Math.pow(Math.abs(d) / d2, d3 - 1.0) * MarginalizedAlphaStableDistribution.gradAbsX(d) / d2;
    }

    private static double gradAbsX(double d) {
        if (d < 0.0) {
            return -1.0;
        }
        if (d > 0.0) {
            return 1.0;
        }
        return Double.NaN;
    }
}

