/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.distributions.AbstractLKJDistribution;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.SymmetricMatrix;

public class LKJCorrelationDistribution
extends AbstractLKJDistribution {
    public static final String TYPE = "LKJCorrelation";

    public LKJCorrelationDistribution(int n, double d) {
        super(n, d);
    }

    public LKJCorrelationDistribution(int n) {
        super(n);
    }

    @Override
    public double logPdf(double[] dArray) {
        assert (dArray.length == LKJCorrelationDistribution.upperTriangularSize(this.dim));
        SymmetricMatrix symmetricMatrix = SymmetricMatrix.compoundCorrelationSymmetricMatrix(dArray, this.dim);
        return this.logPdf(symmetricMatrix);
    }

    private double logPdf(Matrix matrix) {
        double d = 0.0;
        try {
            d = matrix.logDeterminant();
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                return Double.NEGATIVE_INFINITY;
            }
            d *= this.shape - 1.0;
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        return d += this.logNormalizationConstant;
    }

    private double[] gradLogPdf(double[] dArray) {
        assert (dArray.length == LKJCorrelationDistribution.upperTriangularSize(this.dim));
        if (this.shape == 1.0) {
            return new double[dArray.length];
        }
        SymmetricMatrix symmetricMatrix = SymmetricMatrix.compoundCorrelationSymmetricMatrix(dArray, this.dim);
        return LKJCorrelationDistribution.gradLogPdf(symmetricMatrix, this.shape);
    }

    private static double[] gradLogPdf(SymmetricMatrix symmetricMatrix, double d) {
        double[] dArray = SymmetricMatrix.extractUpperTriangular(symmetricMatrix.inverse());
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 2.0 * (d - 1.0) * dArray[i];
        }
        return dArray;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.gradLogPdf((double[])object);
    }
}

