/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.LineFunction;
import dr.math.MFWithGradient;
import dr.math.MinimiserMonitor;
import dr.math.MultivariateFunction;
import dr.math.MultivariateMinimum;
import dr.math.NumericalDerivative;

public class ConjugateGradientSearch
extends MultivariateMinimum {
    public static final int FLETCHER_REEVES_UPDATE = 0;
    public static final int POLAK_RIBIERE_UPDATE = 1;
    public static final int BEALE_SORENSON_HESTENES_STIEFEL_UPDATE = 2;
    public int prin = 0;
    public double defaultStep = 1.0;
    public int conjugateGradientStyle = 2;
    private int numArgs;
    private int numGrad;
    private double lastStep;
    private double[] xvec;
    private double[] gvec;
    private double[] sdir;
    private MFWithGradient fgrad;

    public ConjugateGradientSearch() {
    }

    public ConjugateGradientSearch(int n) {
        this.conjugateGradientStyle = n;
    }

    @Override
    public void optimize(MultivariateFunction multivariateFunction, double[] dArray, double d, double d2) {
        this.optimize(multivariateFunction, dArray, d, d2, null);
    }

    @Override
    public void optimize(MultivariateFunction multivariateFunction, double[] dArray, double d, double d2, MinimiserMonitor minimiserMonitor) {
        double d3;
        boolean bl;
        this.xvec = dArray;
        this.numArgs = multivariateFunction.getNumArguments();
        if (multivariateFunction instanceof MFWithGradient) {
            bl = false;
            this.fgrad = (MFWithGradient)multivariateFunction;
        } else {
            bl = true;
            this.fgrad = null;
        }
        LineFunction lineFunction = new LineFunction(multivariateFunction);
        lineFunction.checkPoint(this.xvec);
        double[] dArray2 = new double[this.numArgs];
        this.copy(dArray2, this.xvec);
        this.numFun = 0;
        this.numGrad = 0;
        this.gvec = new double[this.numArgs];
        if (bl) {
            d3 = multivariateFunction.evaluate(this.xvec);
            ++this.numFun;
            NumericalDerivative.gradient(multivariateFunction, this.xvec, this.gvec);
            this.numFun += 2 * this.numArgs;
        } else {
            d3 = this.fgrad.evaluate(this.xvec, this.gvec);
            ++this.numFun;
            ++this.numGrad;
        }
        double[] dArray3 = new double[this.numArgs];
        this.copy(dArray3, this.gvec);
        this.stopCondition(d3, this.xvec, d, d2, true);
        boolean[] blArray = new boolean[this.numArgs];
        double d4 = lineFunction.checkVariables(this.xvec, this.gvec, blArray);
        if (d4 == 0.0) {
            return;
        }
        this.sdir = new double[this.numArgs];
        this.steepestDescentDirection(this.sdir, this.gvec, blArray);
        lineFunction.update(this.xvec, this.sdir);
        double d5 = this.gradientProjection(this.sdir, this.gvec);
        if (this.prin > 0) {
            System.out.println("--- starting minimization ---");
            System.out.println("... current parameter settings ...");
            System.out.println("...   tolx   ... " + d2);
            System.out.println("...   tolfx   ... " + d);
            System.out.println("... maxFun  ... " + this.maxFun);
            System.out.println();
            this.printVec("... start vector ...", this.xvec);
            System.out.println();
            this.printVec("... start direction ...", this.sdir);
        }
        int n = 0;
        this.lastStep = this.defaultStep;
        while (true) {
            double d6;
            this.lastStep = d6 = this.findStep(lineFunction, d3, d5, bl);
            ++n;
            lineFunction.getPoint(d6, this.xvec);
            lineFunction.checkPoint(this.xvec);
            if (bl) {
                d3 = multivariateFunction.evaluate(this.xvec);
                ++this.numFun;
            } else {
                d3 = this.fgrad.evaluate(this.xvec, this.gvec);
                ++this.numFun;
                ++this.numGrad;
            }
            if (this.stopCondition(d3, this.xvec, d, d2, false) || this.maxFun > 0 && this.numFun > this.maxFun) break;
            if (bl) {
                NumericalDerivative.gradient(multivariateFunction, this.xvec, this.gvec);
                this.numFun += 2 * this.numArgs;
            }
            if ((d4 = (double)lineFunction.checkVariables(this.xvec, this.gvec, blArray)) == 0.0) break;
            this.conjugateGradientDirection(this.sdir, this.gvec, dArray3, blArray);
            lineFunction.checkDirection(this.xvec, this.sdir);
            d5 = this.gradientProjection(this.sdir, this.gvec);
            if (d5 >= 0.0) {
                this.steepestDescentDirection(this.sdir, this.gvec, blArray);
                d5 = this.gradientProjection(this.sdir, this.gvec);
                this.lastStep = this.defaultStep;
            }
            lineFunction.update(this.xvec, this.sdir);
            this.copy(dArray2, this.xvec);
            this.copy(dArray3, this.gvec);
            if (this.prin > 1) {
                System.out.println();
                System.out.println("Function value: " + multivariateFunction.evaluate(this.xvec));
                System.out.println();
                this.printVec("... new vector ...", this.xvec);
                System.out.println();
                this.printVec("... new direction ...", this.sdir);
                System.out.println("... numFun  ... " + this.numFun);
                if (!bl) {
                    System.out.println("... numGrad  ... " + this.numGrad);
                }
                System.out.println("... numLin  ... " + n);
                System.out.println();
            }
            if (minimiserMonitor == null) continue;
            minimiserMonitor.newMinimum(multivariateFunction.evaluate(this.xvec), this.xvec);
        }
        if (this.prin > 0) {
            System.out.println();
            this.printVec("... final vector ...", this.xvec);
            System.out.println("... numFun  ... " + this.numFun);
            System.out.println("... numLin  ... " + n);
            System.out.println();
            System.out.println("--- end of minimization ---");
        }
    }

    private double findStep(LineFunction lineFunction, double d, double d2, boolean bl) {
        double d3 = lineFunction.getUpperBound();
        if (d3 <= 0.0 || d2 == 0.0) {
            return 0.0;
        }
        double d4 = 2.0;
        double d5 = 1.25;
        double d6 = 0.5;
        double d7 = 0.0;
        double d8 = d2;
        double d9 = this.lastStep * d5;
        if (d9 > d3) {
            d9 = d3 * d6;
        }
        double d10 = this.computeDerivative(lineFunction, d9, bl);
        boolean bl2 = false;
        while (d10 <= 0.0 && !bl2) {
            d7 = d9;
            d8 = d10;
            if ((d9 *= d4) > d3) {
                d9 = d3;
                bl2 = true;
            }
            d10 = this.computeDerivative(lineFunction, d9, bl);
        }
        double d11 = d10 <= 0.0 ? d9 : (d7 * d10 - d9 * d8) / (d10 - d8);
        if (d11 >= d3) {
            d11 = d3;
        }
        if (d11 < 0.0) {
            d11 = 0.0;
        }
        return d11;
    }

    private double computeDerivative(LineFunction lineFunction, double d, boolean bl) {
        if (bl) {
            this.numFun += 2;
            return NumericalDerivative.firstDerivative(lineFunction, d);
        }
        double[] dArray = new double[this.numArgs];
        this.copy(dArray, this.xvec);
        lineFunction.getPoint(d, dArray);
        lineFunction.checkPoint(dArray);
        this.fgrad.computeGradient(dArray, this.gvec);
        ++this.numGrad;
        return this.gradientProjection(this.sdir, this.gvec);
    }

    private void conjugateGradientDirection(double[] dArray, double[] dArray2, double[] dArray3, boolean[] blArray) {
        double d = 0.0;
        double d2 = 0.0;
        block5: for (int i = 0; i < this.numArgs; ++i) {
            if (!blArray[i]) continue;
            switch (this.conjugateGradientStyle) {
                case 0: {
                    d2 += dArray2[i] * dArray2[i];
                    d += dArray3[i] * dArray3[i];
                    continue block5;
                }
                case 1: {
                    d2 += dArray2[i] * (dArray2[i] - dArray3[i]);
                    d += dArray3[i] * dArray3[i];
                    continue block5;
                }
                case 2: {
                    d2 += dArray2[i] * (dArray2[i] - dArray3[i]);
                    d += dArray[i] * (dArray2[i] - dArray3[i]);
                }
            }
        }
        double d3 = d2 / d;
        if (d3 < 0.0 || d == 0.0) {
            d3 = 0.0;
        }
        for (int i = 0; i < this.numArgs; ++i) {
            dArray[i] = blArray[i] ? -dArray2[i] + d3 * dArray[i] : 0.0;
        }
    }

    private void steepestDescentDirection(double[] dArray, double[] dArray2, boolean[] blArray) {
        for (int i = 0; i < this.numArgs; ++i) {
            dArray[i] = blArray[i] ? -dArray2[i] : 0.0;
        }
    }

    private double gradientProjection(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = dArray2.length;
        int n = 0;
        while ((double)n < d2) {
            d += dArray2[n] * dArray[n];
            ++n;
        }
        return d;
    }

    private void printVec(String string, double[] dArray) {
        System.out.println(string);
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(dArray[i] + "  ");
        }
        System.out.println();
    }
}

