/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.evomodel.treedatalikelihood.continuous.HashedMissingArray;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.inference.operators.factorAnalysis.FactorAnalysisOperatorAdaptor;
import java.util.HashMap;
import java.util.Map;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;

public class FactorAnalysisStatisticsProvider
implements VariableListener {
    private final FactorAnalysisOperatorAdaptor adaptor;
    private final boolean useInnerProductCache;
    private Map<HashedMissingArray, DenseMatrix64F> innerProductMap = new HashMap<HashedMissingArray, DenseMatrix64F>();
    private final double[][] observedIndicators;
    private boolean needToUpdateCache = true;
    private Parameter[] factorDependentParameters;

    public FactorAnalysisStatisticsProvider(FactorAnalysisOperatorAdaptor factorAnalysisOperatorAdaptor, CacheProvider cacheProvider) {
        this.adaptor = factorAnalysisOperatorAdaptor;
        this.useInnerProductCache = cacheProvider.useCache();
        this.observedIndicators = (double[][])(cacheProvider.useCache() ? this.setupObservedIndicators() : null);
        for (Parameter parameter : this.factorDependentParameters = factorAnalysisOperatorAdaptor.getFactorDependentParameters()) {
            parameter.addParameterListener(this);
        }
    }

    private double[][] setupObservedIndicators() {
        double[][] dArray = new double[this.adaptor.getNumberOfTraits()][this.adaptor.getNumberOfTaxa()];
        for (int i = 0; i < this.adaptor.getNumberOfTraits(); ++i) {
            for (int j = 0; j < this.adaptor.getNumberOfTaxa(); ++j) {
                if (!this.adaptor.isNotMissing(i, j)) continue;
                dArray[i][j] = 1.0;
            }
        }
        return dArray;
    }

    public void getFactorMeans(double[] dArray) {
        int n = this.adaptor.getNumberOfTaxa();
        int n2 = this.adaptor.getNumberOfFactors();
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n; ++j) {
                d += this.adaptor.getFactorValue(i, j);
            }
            dArray[i] = d / (double)n;
        }
    }

    public void getLoadingsInnerProduct(double[][] dArray) {
        int n = this.adaptor.getNumberOfFactors();
        int n2 = this.adaptor.getNumberOfTraits();
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double d = 0.0;
                int n3 = i * n2;
                int n4 = j * n2;
                for (int k = 0; k < n2; ++k) {
                    double d2 = this.adaptor.getLoadingsValue(k + n3);
                    double d3 = this.adaptor.getLoadingsValue(k + n4);
                    d += d2 * d3;
                }
                dArray[i][j] = d;
                if (i == j) continue;
                dArray[j][i] = d;
            }
        }
    }

    public void getFactorInnerProduct(int n, int n2, double[][] dArray) {
        this.getFactorInnerProduct(n, n2, dArray, true);
    }

    public void getFactorInnerProduct(int n, int n2, double[][] dArray, boolean bl) {
        D1Matrix64F d1Matrix64F = null;
        HashedMissingArray hashedMissingArray = null;
        if (this.useInnerProductCache) {
            this.checkNeedToUpdateInnerProduct();
            double[] dArray2 = this.observedIndicators[n];
            hashedMissingArray = new HashedMissingArray(dArray2);
            d1Matrix64F = this.innerProductMap.get(hashedMissingArray);
        }
        if (!this.useInnerProductCache || d1Matrix64F == null) {
            int n3 = this.adaptor.getNumberOfTaxa();
            for (int i = 0; i < n2; ++i) {
                for (int j = i; j < n2; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < n3; ++k) {
                        if (bl && !this.adaptor.isNotMissing(n, k)) continue;
                        d += this.adaptor.getFactorValue(i, k) * this.adaptor.getFactorValue(j, k);
                    }
                    dArray[i][j] = d;
                    if (i == j) continue;
                    dArray[j][i] = d;
                }
            }
            if (this.useInnerProductCache) {
                this.innerProductMap.put(hashedMissingArray, new DenseMatrix64F(dArray));
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                System.arraycopy(d1Matrix64F.getData(), i * n2, dArray[i], 0, n2);
            }
        }
    }

    public void getScaledFactorInnerProduct(int n, int n2, double[][] dArray) {
        this.getFactorInnerProduct(n, n2, dArray);
        double d = this.adaptor.getColumnPrecision(n);
        for (int i = 0; i < n2; ++i) {
            double[] dArray2 = dArray[i];
            int n3 = i;
            dArray2[n3] = dArray2[n3] * d;
            for (int j = i + 1; j < n2; ++j) {
                double[] dArray3 = dArray[i];
                int n4 = j;
                dArray3[n4] = dArray3[n4] * d;
                dArray[j][i] = dArray[i][j];
            }
        }
    }

    public void getFactorTraitProduct(int n, int n2, double[] dArray) {
        int n3 = this.adaptor.getNumberOfTaxa();
        for (int i = 0; i < n2; ++i) {
            double d = 0.0;
            for (int j = 0; j < n3; ++j) {
                if (!this.adaptor.isNotMissing(n, j)) continue;
                d += this.adaptor.getFactorValue(i, j) * this.adaptor.getDataValue(n, j);
            }
            dArray[i] = d;
        }
    }

    public void getScaledFactorTraitProduct(int n, int n2, double[] dArray) {
        this.getFactorTraitProduct(n, n2, dArray);
        double d = this.adaptor.getColumnPrecision(n);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3++;
            dArray[n4] = dArray[n4] * d;
        }
    }

    public void checkNeedToUpdateInnerProduct() {
        if (this.useInnerProductCache && this.needToUpdateCache) {
            this.innerProductMap.clear();
            this.needToUpdateCache = false;
        }
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        for (Parameter parameter : this.factorDependentParameters) {
            if (variable != parameter) continue;
            this.needToUpdateCache = true;
        }
    }

    public FactorAnalysisOperatorAdaptor getAdaptor() {
        return this.adaptor;
    }

    public boolean useCache() {
        return this.useInnerProductCache;
    }

    public static enum CacheProvider {
        USE_CACHE{

            @Override
            boolean useCache() {
                return true;
            }
        }
        ,
        NO_CACHE{

            @Override
            boolean useCache() {
                return false;
            }
        };


        abstract boolean useCache();
    }
}

