/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.BoundedSpace;
import dr.inference.model.Parameter;
import dr.inference.model.TransformedParameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.RandomWalkOperator;
import dr.math.matrixAlgebra.Matrix;

public class TransformedParameterRandomWalkOperator
extends RandomWalkOperator {
    private static boolean DEBUG = false;
    private static boolean checkValid = true;
    private final BoundedSpace generalBounds;

    public TransformedParameterRandomWalkOperator(TransformedParameter transformedParameter, double d, RandomWalkOperator.BoundaryCondition boundaryCondition, double d2, AdaptationMode adaptationMode) {
        super(transformedParameter, d, boundaryCondition, d2, adaptationMode);
        this.generalBounds = null;
    }

    public TransformedParameterRandomWalkOperator(TransformedParameter transformedParameter, RandomWalkOperator randomWalkOperator) {
        super((Parameter)transformedParameter, randomWalkOperator.getWindowSize(), randomWalkOperator.getBoundaryCondition(), randomWalkOperator.getWeight(), randomWalkOperator.getMode(), randomWalkOperator.getUpdateMap());
        this.generalBounds = null;
    }

    public TransformedParameterRandomWalkOperator(RandomWalkOperator randomWalkOperator, BoundedSpace boundedSpace) {
        super((Parameter)((TransformedParameter)randomWalkOperator.getParameter()), randomWalkOperator.getWindowSize(), randomWalkOperator.getBoundaryCondition(), randomWalkOperator.getWeight(), randomWalkOperator.getMode(), randomWalkOperator.getUpdateMap());
        this.generalBounds = boundedSpace;
    }

    @Override
    public double doOperation() {
        double[] dArray = ((TransformedParameter)this.parameter).getParameterUntransformedValues();
        if (DEBUG) {
            System.err.println("oldValues: " + new Matrix(dArray, dArray.length, 1));
            System.err.println("oldValuesTrans: " + new Matrix(this.parameter.getParameterValues(), dArray.length, 1));
        }
        double d = super.doOperation();
        double[] dArray2 = ((TransformedParameter)this.parameter).getParameterUntransformedValues();
        if (DEBUG) {
            System.err.println("newValues: " + new Matrix(dArray2, dArray2.length, 1));
            System.err.println("newValuesTrans: " + new Matrix(this.parameter.getParameterValues(), dArray2.length, 1));
        }
        if (checkValid) {
            if (this.generalBounds == null && !this.parameter.isWithinBounds()) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.generalBounds != null && !this.generalBounds.isWithinBounds(this.parameter.getParameterValues())) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        d += ((TransformedParameter)this.parameter).diffLogJacobian(dArray, dArray2);
        if (DEBUG) {
            System.err.println("ratio: " + d);
        }
        return d;
    }
}

