/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.util.Taxon;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MaskFromTree
extends Parameter.Default
implements ModelListener {
    public static final String MASK_FROM_TREE = "maskFromTree";
    public static final String MASK_LENGTH = "maskLength";
    private TreeModel tree;
    private Taxon taxon;
    private TreeParameterModel branchRates;
    private int maskLength;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), new ElementRule(Taxon.class), AttributeRule.newStringRule("maskLength", true)};

        @Override
        public String getParserName() {
            return MaskFromTree.MASK_FROM_TREE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            Taxon taxon = (Taxon)xMLObject.getChild(Taxon.class);
            int n = xMLObject.getAttribute(MaskFromTree.MASK_LENGTH, 0);
            int n2 = treeModel.getNodeCount() - 1;
            MaskFromTree maskFromTree = new MaskFromTree(treeModel, taxon, n2, n);
            return maskFromTree;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Masks ancestral (off-root) branch (and optional addnl branches) to a specific reference taxon on a random tree";
        }

        @Override
        public Class getReturnType() {
            return MaskFromTree.class;
        }
    };

    public MaskFromTree(TreeModel treeModel, Taxon taxon, int n, int n2) {
        super(n);
        this.tree = treeModel;
        this.taxon = taxon;
        this.branchRates = new TreeParameterModel((MutableTreeModel)treeModel, (Parameter)this, false);
        treeModel.addModelListener(this);
        treeModel.addModelRestoreListener(this);
        this.maskLength = n2;
        this.updateMask();
    }

    void updateMask() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.getDimension(); ++n3) {
            this.setParameterValueQuietly(n3, 1.0);
        }
        n3 = this.tree.getTaxonIndex(this.taxon.getId());
        NodeRef nodeRef = this.tree.getNode(n3);
        NodeRef nodeRef2 = this.tree.getRoot();
        NodeRef[] nodeRefArray = new NodeRef[this.maskLength + 1];
        for (n2 = 0; n2 < nodeRefArray.length; ++n2) {
            nodeRefArray[n2] = nodeRef;
        }
        n2 = 0;
        while (this.tree.getParent(nodeRefArray[0]) != nodeRef2) {
            ++n2;
            for (n = this.maskLength; n > 0; --n) {
                if (n2 <= n) continue;
                nodeRefArray[n] = nodeRefArray[n - 1];
            }
            nodeRefArray[0] = this.tree.getParent(nodeRefArray[0]);
        }
        for (int i = 0; i < nodeRefArray.length; ++i) {
            n = this.branchRates.getParameterIndexFromNodeNumber(nodeRefArray[i].getNumber());
            this.setParameterValue(n, 0.0);
        }
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getParameterName() {
        return null;
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Bounds<Double> getBounds() {
        return null;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double removeDimension(int n) {
        return 0.0;
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
        super.storeParameterValues();
        this.updateMask();
    }

    @Override
    public void modelRestored(Model model) {
        super.restoreParameterValues();
    }
}

