/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import beagle.Beagle;
import dr.evolution.tree.Tree;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.treedatalikelihood.BufferIndexHelper;
import dr.evomodel.treedatalikelihood.EvolutionaryProcessDelegate;
import dr.evomodel.treedatalikelihood.PreOrderSettings;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class SubstitutionModelDelegate
implements EvolutionaryProcessDelegate,
Serializable {
    private static final boolean DEBUG = false;
    private static final boolean RUN_IN_SERIES = false;
    public static final boolean MEASURE_RUN_TIME = false;
    private final PreOrderSettings settings;
    public double updateTime;
    public double convolveTime;
    static final int BUFFER_POOL_SIZE_DEFAULT = 100;
    private final Tree tree;
    private final List<SubstitutionModel> substitutionModelList;
    private final BranchModel branchModel;
    private final int eigenCount;
    private final int nodeCount;
    private final int extraBufferCount;
    private final int reserveBufferIndex;
    private final BufferIndexHelper eigenBufferHelper;
    private final BufferIndexHelper matrixBufferHelper;
    private Deque<Integer> availableBuffers = new ArrayDeque<Integer>();

    public SubstitutionModelDelegate(Tree tree, BranchModel branchModel) {
        this(tree, branchModel, 0, 100, PreOrderSettings.getDefault());
    }

    public SubstitutionModelDelegate(Tree tree, BranchModel branchModel, int n) {
        this(tree, branchModel, n, 100, PreOrderSettings.getDefault());
    }

    public SubstitutionModelDelegate(Tree tree, BranchModel branchModel, int n, int n2) {
        this(tree, branchModel, n, n2, PreOrderSettings.getDefault());
    }

    public SubstitutionModelDelegate(Tree tree, BranchModel branchModel, PreOrderSettings preOrderSettings) {
        this(tree, branchModel, 0, 100, preOrderSettings);
    }

    public SubstitutionModelDelegate(Tree tree, BranchModel branchModel, int n, int n2, PreOrderSettings preOrderSettings) {
        this.tree = tree;
        this.substitutionModelList = branchModel.getSubstitutionModels();
        this.branchModel = branchModel;
        this.eigenCount = this.substitutionModelList.size();
        this.nodeCount = tree.getNodeCount();
        this.eigenBufferHelper = new BufferIndexHelper(this.eigenCount, 0, n);
        this.matrixBufferHelper = new BufferIndexHelper(this.nodeCount, 0, n);
        int n3 = branchModel.requiresMatrixConvolution() ? (n2 > 0 ? n2 : 100) : (this.extraBufferCount = 0);
        if (branchModel.requiresMatrixConvolution() && this.extraBufferCount < this.eigenCount) {
            throw new RuntimeException("SubstitutionModelDelegate requires at least " + this.eigenCount + " extra buffers to convolve matrices");
        }
        for (int i = 0; i < this.extraBufferCount; ++i) {
            this.pushAvailableBuffer(i + this.matrixBufferHelper.getBufferCount());
        }
        this.reserveBufferIndex = this.matrixBufferHelper.getBufferCount() + this.extraBufferCount;
        this.settings = preOrderSettings;
    }

    @Override
    public boolean canReturnComplexDiagonalization() {
        for (SubstitutionModel substitutionModel : this.substitutionModelList) {
            if (!substitutionModel.canReturnComplexDiagonalization()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEigenBufferCount() {
        return this.eigenBufferHelper.getBufferCount();
    }

    @Override
    public int getMatrixBufferCount() {
        return this.matrixBufferHelper.getBufferCount() + this.extraBufferCount + 1;
    }

    @Override
    public int getInfinitesimalMatrixBufferIndex(int n) {
        return this.getMatrixBufferCount() + this.getEigenIndex(n);
    }

    private int getInfinitesimalMatrixBufferIndexByEigenIndex(int n) {
        return this.getMatrixBufferCount() + n;
    }

    @Override
    public int getInfinitesimalSquaredMatrixBufferIndex(int n) {
        return this.getMatrixBufferCount() + this.getEigenBufferCount() + this.getEigenIndex(n);
    }

    @Override
    public int getFirstOrderDifferentialMatrixBufferIndex(int n) {
        int n2 = this.matrixBufferHelper.getBufferCount() + this.getInfinitesimalMatrixBufferCount(this.settings) + n;
        return n2;
    }

    @Override
    public int getSecondOrderDifferentialMatrixBufferIndex(int n) {
        return this.getFirstOrderDifferentialMatrixBufferIndex(n) + this.nodeCount - 1;
    }

    @Override
    public void cacheInfinitesimalMatrix(Beagle beagle, int n, double[] dArray) {
        beagle.setDifferentialMatrix(this.getInfinitesimalMatrixBufferIndex(n), dArray);
    }

    @Override
    public void cacheInfinitesimalSquaredMatrix(Beagle beagle, int n, double[] dArray) {
        beagle.setDifferentialMatrix(this.getInfinitesimalSquaredMatrixBufferIndex(n), dArray);
    }

    @Override
    public void cacheFirstOrderDifferentialMatrix(Beagle beagle, int n, double[] dArray) {
        beagle.setDifferentialMatrix(this.getFirstOrderDifferentialMatrixBufferIndex(n), dArray);
    }

    private int getSquaredInfinitesimalMatrixBufferIndexByEigenIndex(int n) {
        return this.getMatrixBufferCount() + this.getEigenBufferCount() + n;
    }

    @Override
    public int getCachedMatrixBufferCount(PreOrderSettings preOrderSettings) {
        int n = this.getInfinitesimalMatrixBufferCount(preOrderSettings) + this.getDifferentialMassMatrixBufferCount(preOrderSettings);
        return n;
    }

    private int getInfinitesimalMatrixBufferCount(PreOrderSettings preOrderSettings) {
        if (preOrderSettings.branchRateDerivative) {
            return 2 * this.getEigenBufferCount();
        }
        return 0;
    }

    private int getDifferentialMassMatrixBufferCount(PreOrderSettings preOrderSettings) {
        if (preOrderSettings.branchInfinitesimalDerivative) {
            return 2 * (this.nodeCount - 1);
        }
        return 0;
    }

    @Override
    public int getSubstitutionModelCount() {
        return this.substitutionModelList.size();
    }

    @Override
    public SubstitutionModel getSubstitutionModel(int n) {
        return this.substitutionModelList.get(n);
    }

    @Override
    public int getEigenIndex(int n) {
        return this.eigenBufferHelper.getOffsetIndex(n);
    }

    @Override
    public int getMatrixIndex(int n) {
        return this.matrixBufferHelper.getOffsetIndex(n);
    }

    @Override
    public double[] getRootStateFrequencies() {
        return this.branchModel.getRootFrequencyModel().getFrequencies();
    }

    @Override
    public void updateSubstitutionModels(Beagle beagle, boolean bl) {
        for (int i = 0; i < this.eigenCount; ++i) {
            if (bl) {
                this.eigenBufferHelper.flipOffset(i);
            }
            SubstitutionModel substitutionModel = this.substitutionModelList.get(i);
            EigenDecomposition eigenDecomposition = substitutionModel.getEigenDecomposition();
            beagle.setEigenDecomposition(this.eigenBufferHelper.getOffsetIndex(i), eigenDecomposition.getEigenVectors(), eigenDecomposition.getInverseEigenVectors(), eigenDecomposition.getEigenValues());
        }
    }

    @Override
    public SubstitutionModel getSubstitutionModelForBranch(int n) {
        BranchModel.Mapping mapping = this.branchModel.getBranchModelMapping(this.tree.getNode(n));
        int[] nArray = mapping.getOrder();
        if (nArray.length > 1) {
            throw new RuntimeException("Not yet implemented");
        }
        return this.getSubstitutionModel(nArray[0]);
    }

    @Override
    public void updateTransitionMatrices(Beagle beagle, int[] nArray, double[] dArray, int n, boolean bl) {
        int[][] nArray2 = new int[this.eigenCount][n];
        double[][] dArray2 = new double[this.eigenCount][n];
        int[] nArray3 = new int[this.eigenCount];
        ArrayList<Deque<Integer>> arrayList = new ArrayList<Deque<Integer>>();
        for (int i = 0; i < n; ++i) {
            BranchModel.Mapping mapping = this.branchModel.getBranchModelMapping(this.tree.getNode(nArray[i]));
            int[] nArray4 = mapping.getOrder();
            double[] dArray3 = mapping.getWeights();
            if (nArray4.length == 1) {
                int n2 = nArray4[0];
                if (bl) {
                    this.matrixBufferHelper.flipOffset(nArray[i]);
                }
                nArray2[n2][nArray3[n2]] = this.matrixBufferHelper.getOffsetIndex(nArray[i]);
                dArray2[n2][nArray3[n2]] = dArray[i];
                int n3 = n2;
                nArray3[n3] = nArray3[n3] + 1;
                continue;
            }
            double d = 0.0;
            for (double d2 : dArray3) {
                d += d2;
            }
            if (this.getAvailableBufferCount() < nArray4.length) {
                if (bl) {
                    throw new UnsupportedOperationException("flipping not implemented for Epoch models");
                }
                this.computeTransitionMatrices(beagle, nArray2, dArray2, nArray3);
                this.convolveMatrices(beagle, arrayList);
                for (int j = 0; j < this.eigenCount; ++j) {
                    nArray3[j] = 0;
                }
            }
            Object object = new ArrayDeque();
            for (int j = 0; j < nArray4.length; ++j) {
                int n4 = this.popAvailableBuffer();
                if (n4 < 0) {
                    throw new RuntimeException("Ran out of buffers for transition matrices - computing current list.");
                }
                int n5 = nArray4[j];
                nArray2[n5][nArray3[n5]] = n4;
                dArray2[n5][nArray3[n5]] = dArray3[j] * dArray[i] / d;
                int n6 = n5;
                nArray3[n6] = nArray3[n6] + 1;
                object.add(n4);
            }
            object.add(this.matrixBufferHelper.getOffsetIndex(nArray[i]));
            arrayList.add((Deque<Integer>)object);
        }
        this.computeTransitionMatrices(beagle, nArray2, dArray2, nArray3);
        this.convolveMatrices(beagle, arrayList);
    }

    @Override
    public void flipTransitionMatrices(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            this.matrixBufferHelper.flipOffset(nArray[i]);
        }
    }

    private void computeTransitionMatrices(Beagle beagle, int[][] nArray, double[][] dArray, int[] nArray2) {
        for (int i = 0; i < this.eigenCount; ++i) {
            if (nArray2[i] <= 0) continue;
            beagle.updateTransitionMatrices(this.eigenBufferHelper.getOffsetIndex(i), nArray[i], null, null, dArray[i], nArray2[i]);
        }
    }

    private void convolveMatrices(Beagle beagle, List<Deque<Integer>> list) {
        while (list.size() > 0) {
            int[] nArray = new int[this.nodeCount];
            int[] nArray2 = new int[this.nodeCount];
            int[] nArray3 = new int[this.nodeCount];
            int n = 0;
            ArrayList<Deque<Integer>> arrayList = new ArrayList<Deque<Integer>>();
            for (Deque<Integer> deque : list) {
                if (deque.size() > 3) {
                    int n2;
                    boolean bl;
                    nArray[n] = deque.pop();
                    nArray2[n] = deque.pop();
                    do {
                        bl = true;
                        n2 = this.popAvailableBuffer();
                        if (n2 >= 0) continue;
                        if (n > 0) {
                            this.convolveAndRelease(beagle, nArray, nArray2, nArray3, n);
                            nArray[0] = nArray[n];
                            nArray2[0] = nArray2[n];
                            n = 0;
                            bl = false;
                            continue;
                        }
                        nArray3[n] = this.getReserveBuffer();
                        this.convolveAndRelease(beagle, nArray, nArray2, nArray3, 1);
                        deque.push(this.getReserveBuffer());
                        bl = true;
                    } while (!bl);
                    if (n2 >= 0) {
                        nArray3[n] = n2;
                        deque.push(n2);
                        ++n;
                    }
                } else if (deque.size() == 3) {
                    nArray[n] = deque.pop();
                    nArray2[n] = deque.pop();
                    nArray3[n] = deque.pop();
                    ++n;
                } else {
                    throw new RuntimeException("Unexpected convolve list size");
                }
                if (deque.size() != 0) continue;
                arrayList.add(deque);
            }
            this.convolveAndRelease(beagle, nArray, nArray2, nArray3, n);
            list.removeAll(arrayList);
        }
    }

    private void convolveAndRelease(Beagle beagle, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        beagle.convolveTransitionMatrices(nArray, nArray2, nArray3, n);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= this.matrixBufferHelper.getBufferCount() && nArray[i] != this.reserveBufferIndex) {
                this.pushAvailableBuffer(nArray[i]);
            }
            if (nArray2[i] < this.matrixBufferHelper.getBufferCount() || nArray2[i] == this.reserveBufferIndex) continue;
            this.pushAvailableBuffer(nArray2[i]);
        }
    }

    private int getAvailableBufferCount() {
        return this.availableBuffers.size();
    }

    private int popAvailableBuffer() {
        if (this.availableBuffers.isEmpty()) {
            return -1;
        }
        return this.availableBuffers.pop();
    }

    private int getReserveBuffer() {
        return this.reserveBufferIndex;
    }

    private void pushAvailableBuffer(int n) {
        this.availableBuffers.push(n);
    }

    @Override
    public void storeState() {
        this.eigenBufferHelper.storeState();
        this.matrixBufferHelper.storeState();
    }

    @Override
    public void restoreState() {
        this.eigenBufferHelper.restoreState();
        this.matrixBufferHelper.restoreState();
    }
}

