/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.NodeRef;
import dr.evomodel.speciation.SpeciesTreeModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.CompoundModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;

public class SpeciesTreeBMPrior
extends Likelihood.Abstract {
    private final SpeciesTreeModel sTree;
    private final ParametricDistributionModel tips;
    private final Parameter popSigma;
    private final Parameter stSigma;
    private static final double d1 = 1.0 - Math.exp(-1.0);
    private static final double f2 = -0.5 * Math.log(Math.PI * 2);
    private final boolean logRoot;

    public SpeciesTreeBMPrior(SpeciesTreeModel speciesTreeModel, Parameter parameter, Parameter parameter2, ParametricDistributionModel parametricDistributionModel, boolean bl) {
        super(new CompoundModel("STBMprior"));
        this.sTree = speciesTreeModel;
        this.popSigma = parameter;
        this.stSigma = parameter2;
        this.tips = parametricDistributionModel;
        this.logRoot = bl;
        CompoundModel compoundModel = (CompoundModel)this.getModel();
        compoundModel.addModel(parametricDistributionModel);
        compoundModel.addModel(speciesTreeModel);
    }

    @Override
    protected double calculateLogLikelihood() {
        double d = 0.0;
        NodeRef nodeRef = this.sTree.getRoot();
        double d2 = this.sTree.getNodeHeight(nodeRef);
        SpeciesTreeModel.RawPopulationHelper rawPopulationHelper = this.sTree.getPopulationHelper();
        double d3 = d2;
        double d4 = this.stSigma.getParameterValue(0);
        double d5 = 2.0 * d4 * d4;
        int n = 0;
        double[] dArray = new double[2];
        for (int i = 0; i < this.sTree.getNodeCount(); ++i) {
            NodeRef nodeRef2 = this.sTree.getNode(i);
            if (this.sTree.isExternal(nodeRef2)) {
                d += this.tips.logPdf(rawPopulationHelper.tipPopulation(nodeRef2));
                continue;
            }
            for (int j = 0; j < 2; ++j) {
                NodeRef nodeRef3 = this.sTree.getChild(nodeRef2, j);
                rawPopulationHelper.getPopulations(nodeRef2, j, dArray);
                double d6 = this.sTree.getBranchLength(nodeRef3) / d3;
                double d7 = (dArray[1] - dArray[0]) / d3;
                d -= d7 * d7 / (d5 * d6);
                d -= 0.5 * Math.log(d6);
                ++n;
            }
        }
        if (!rawPopulationHelper.perSpeciesPopulation()) {
            rawPopulationHelper.getRootPopulations(dArray);
            double d8 = rawPopulationHelper.geneTreesRootHeight() / d3 - 1.0;
            double d9 = this.logRoot ? Math.log(dArray[1] / dArray[0]) : (dArray[1] - dArray[0]) / d3;
            d -= d9 * d9 / (d5 * d8);
            d -= 0.5 * Math.log(d8);
            ++n;
        }
        d += (double)n * (f2 - Math.log(d4));
        if (rawPopulationHelper.perSpeciesPopulation()) {
            d4 = (this.popSigma != null ? this.popSigma : this.stSigma).getParameterValue(0);
            d5 = 2.0 * d4 * d4;
            for (n = 0; n < rawPopulationHelper.nSpecies(); ++n) {
                dArray = rawPopulationHelper.getTimes(n);
                double[] dArray2 = rawPopulationHelper.getPops(n);
                double d10 = dArray[dArray.length - 1];
                double d11 = 0.0;
                double d12 = dArray2[0] / d10;
                double d13 = 0.0;
                for (int i = 1; i < dArray.length; ++i) {
                    double d14 = dArray2[i] / d10;
                    double d15 = (dArray[i - 1] - d13) / d10;
                    d11 -= (d14 - d12) * (d14 - d12) / (d5 * d15);
                    d11 -= 0.5 * Math.log(d15);
                    d12 = d14;
                    d13 = dArray[i - 1];
                }
                d += (d11 += (double)(dArray.length - 1) * (f2 - Math.log(d4)));
            }
        }
        return d;
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }
}

