/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeAttributeProvider;
import dr.evomodel.treedatalikelihood.hmc.AbstractPrecisionGradient;
import dr.inference.model.AbstractModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MultivariateDiffusionModel
extends AbstractModel
implements TreeAttributeProvider {
    public static final String DIFFUSION_PROCESS = "multivariateDiffusionModel";
    public static final String DIFFUSION_CONSTANT = "precisionMatrix";
    public static final String PRECISION_TREE_ATTRIBUTE = "precision";
    public static final double LOG2PI = Math.log(Math.PI * 2);
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("precisionMatrix", new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class)})};

        @Override
        public String getParserName() {
            return MultivariateDiffusionModel.DIFFUSION_PROCESS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            CholeskyDecomposition choleskyDecomposition;
            XMLObject xMLObject2 = xMLObject.getChild(MultivariateDiffusionModel.DIFFUSION_CONSTANT);
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject2.getChild(MatrixParameterInterface.class);
            try {
                choleskyDecomposition = new CholeskyDecomposition(matrixParameterInterface.getParameterAsMatrix());
            }
            catch (IllegalDimension illegalDimension) {
                throw new XMLParseException("precisionMatrix must be a square matrix.");
            }
            if (!choleskyDecomposition.isSPD()) {
                throw new XMLParseException("precisionMatrix must be a positive definite matrix.");
            }
            return new MultivariateDiffusionModel(matrixParameterInterface);
        }

        @Override
        public String getParserDescription() {
            return "Describes a multivariate normal diffusion process.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MultivariateDiffusionModel.class;
        }
    };
    protected MatrixParameterInterface diffusionPrecisionMatrixParameter;
    private double determinatePrecisionMatrix;
    private double savedDeterminatePrecisionMatrix;
    private double[][] diffusionPrecisionMatrix;
    private double[][] savedDiffusionPrecisionMatrix;
    private boolean variableChanged = true;
    private boolean storedVariableChanged;

    public MultivariateDiffusionModel(MatrixParameterInterface matrixParameterInterface) {
        super(DIFFUSION_PROCESS);
        this.diffusionPrecisionMatrixParameter = matrixParameterInterface;
        this.calculatePrecisionInfo();
        this.addVariable(matrixParameterInterface);
    }

    public MultivariateDiffusionModel() {
        super(DIFFUSION_PROCESS);
    }

    public void check(Parameter parameter) throws XMLParseException {
        assert (parameter != null);
    }

    public MatrixParameterInterface getPrecisionParameter() {
        this.checkVariableChanged();
        return this.diffusionPrecisionMatrixParameter;
    }

    public double[][] getPrecisionmatrix() {
        if (this.diffusionPrecisionMatrixParameter != null) {
            this.checkVariableChanged();
            return this.diffusionPrecisionMatrixParameter.getParameterAsMatrix();
        }
        return null;
    }

    public double[] getPrecisionmatrixAsVector() {
        return AbstractPrecisionGradient.flatten(this.getPrecisionmatrix());
    }

    public double getDeterminantPrecisionMatrix() {
        this.checkVariableChanged();
        return this.determinatePrecisionMatrix;
    }

    public double getLogLikelihood(double[] dArray, double[] dArray2, double d) {
        if (d == 0.0) {
            boolean bl = true;
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] == dArray2[i]) continue;
                bl = false;
                break;
            }
            if (bl) {
                return 0.0;
            }
            return Double.NEGATIVE_INFINITY;
        }
        return this.calculateLogDensity(dArray, dArray2, d);
    }

    protected void checkVariableChanged() {
        if (this.variableChanged) {
            this.calculatePrecisionInfo();
            this.variableChanged = false;
        }
    }

    protected double calculateLogDensity(double[] dArray, double[] dArray2, double d) {
        this.checkVariableChanged();
        double d2 = Math.log(this.determinatePrecisionMatrix);
        return MultivariateNormalDistribution.logPdf(dArray2, dArray, this.diffusionPrecisionMatrix, d2, d);
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{1.0, 2.0};
        double[] dArray2 = new double[]{0.0, 0.0};
        double[][] dArrayArray = new double[][]{{2.0, 0.5}, {0.5, 1.0}};
        double d = 0.2;
        MatrixParameter matrixParameter = new MatrixParameter("Hello");
        matrixParameter.addParameter(new Parameter.Default(dArrayArray[0]));
        matrixParameter.addParameter(new Parameter.Default(dArrayArray[1]));
        MultivariateDiffusionModel multivariateDiffusionModel = new MultivariateDiffusionModel(matrixParameter);
        System.err.println("logPDF = " + multivariateDiffusionModel.calculateLogDensity(dArray, dArray2, d));
        System.err.println("Should be -19.948");
    }

    protected void calculatePrecisionInfo() {
        this.diffusionPrecisionMatrix = this.diffusionPrecisionMatrixParameter.getParameterAsMatrix();
        this.determinatePrecisionMatrix = Math.exp(MultivariateNormalDistribution.calculatePrecisionMatrixLogDeterminate(this.diffusionPrecisionMatrix));
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.variableChanged = true;
    }

    @Override
    protected void storeState() {
        this.savedDeterminatePrecisionMatrix = this.determinatePrecisionMatrix;
        this.savedDiffusionPrecisionMatrix = this.diffusionPrecisionMatrix;
        this.storedVariableChanged = this.variableChanged;
    }

    @Override
    protected void restoreState() {
        this.determinatePrecisionMatrix = this.savedDeterminatePrecisionMatrix;
        this.diffusionPrecisionMatrix = this.savedDiffusionPrecisionMatrix;
        this.variableChanged = this.storedVariableChanged;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public String[] getTreeAttributeLabel() {
        return new String[]{PRECISION_TREE_ATTRIBUTE};
    }

    @Override
    public String[] getAttributeForTree(Tree tree) {
        if (this.diffusionPrecisionMatrixParameter != null) {
            return new String[]{this.diffusionPrecisionMatrixParameter.toSymmetricString()};
        }
        this.diffusionPrecisionMatrixParameter.toString();
        return new String[]{"null"};
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }
}

