/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.bigfasttree.thorney;

import dr.evomodel.bigfasttree.thorney.ConstrainableTreeOperator;
import dr.evomodel.bigfasttree.thorney.ConstrainedTreeModel;
import dr.evomodel.operators.AbstractAdaptableTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.math.Poisson;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;

public class ConstrainedTreeOperator
extends AbstractAdaptableTreeOperator {
    public static final String TARGET_ACCEPTANCE = "targetAcceptance";
    public static final String MEAN_COUNT = "meanCount";
    public static final String FIXED_COUNT = "fixedCount";
    private final ConstrainedTreeModel constrainedTreeModel;
    private final ConstrainableTreeOperator operator;
    private final double[] subtreeSizes;
    private double nonshiftedMean;
    private final int count;
    private int maxOperations;

    public static ConstrainedTreeOperator parse(ConstrainedTreeModel constrainedTreeModel, double d, ConstrainableTreeOperator constrainableTreeOperator, XMLObject xMLObject) throws XMLParseException {
        AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
        adaptationMode = AdaptationMode.ADAPTATION_OFF;
        double d2 = xMLObject.getAttribute(MEAN_COUNT, 1.0);
        double d3 = xMLObject.getAttribute(TARGET_ACCEPTANCE, 0.234);
        if (xMLObject.hasAttribute(MEAN_COUNT)) {
            throw new XMLParseException("Constrained operator with id " + constrainableTreeOperator.getOperatorName() + ":  meanCount  is not supported");
        }
        if (xMLObject.hasAttribute(FIXED_COUNT)) {
            throw new XMLParseException("Constrained operator with id " + constrainableTreeOperator.getOperatorName() + ":  fixedCount  is not supported");
        }
        if (xMLObject.hasAttribute(MEAN_COUNT) && xMLObject.hasAttribute(FIXED_COUNT)) {
            throw new XMLParseException("Constrained operator with id " + constrainableTreeOperator.getOperatorName() + ":  meanCount and fixedCount are mutually exclusive");
        }
        return new ConstrainedTreeOperator(constrainedTreeModel, d, constrainableTreeOperator, d2, 1, adaptationMode, d3);
    }

    public ConstrainedTreeOperator(ConstrainedTreeModel constrainedTreeModel, double d, ConstrainableTreeOperator constrainableTreeOperator, double d2, int n, AdaptationMode adaptationMode, double d3) {
        super(adaptationMode, d3);
        this.setWeight(d);
        this.constrainedTreeModel = constrainedTreeModel;
        this.operator = constrainableTreeOperator;
        if (constrainedTreeModel.getInternalNodeCount() == constrainedTreeModel.getSubtreeCount()) {
            throw new IllegalArgumentException(this.getOperatorName() + " is designed to resolve polytomies; however, the constrained tree is fully resolved. Please remove this operator or provide an unresolved constraints tree.");
        }
        this.subtreeSizes = new double[constrainedTreeModel.getSubtreeCount()];
        int n2 = 1;
        for (int i = 0; i < constrainedTreeModel.getSubtreeCount(); ++i) {
            this.subtreeSizes[i] = (double)constrainedTreeModel.getSubtree(i).getInternalNodeCount() - 1.0;
            if (!(this.subtreeSizes[i] > 0.0)) continue;
            ++n2;
        }
        this.nonshiftedMean = d2;
        this.count = n;
    }

    @Override
    public String getOperatorName() {
        return "Constrained  " + this.operator.getOperatorName();
    }

    @Override
    public double doOperation() {
        int n = 1;
        double[] dArray = new double[this.subtreeSizes.length];
        System.arraycopy(this.subtreeSizes, 0, dArray, 0, this.subtreeSizes.length);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray[i] = n2 = MathUtils.randomChoicePDF(dArray);
            dArray[n2] = 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            TreeModel treeModel = this.constrainedTreeModel.getSubtree(nArray[i]);
            d += this.operator.doOperation(treeModel);
        }
        return d;
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.nonshiftedMean = Math.exp(d);
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.nonshiftedMean);
    }

    @Override
    public double getRawParameter() {
        return this.nonshiftedMean;
    }

    @Override
    public String getAdaptableParameterName() {
        return "unshiftedMean";
    }

    private int getOperationCount() {
        if (this.getMode() == AdaptationMode.ADAPTATION_OFF) {
            return this.count;
        }
        int n = Poisson.nextPoisson(this.nonshiftedMean) + 1;
        return Math.min(n, this.maxOperations);
    }
}

