/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.util.Taxon;
import dr.evomodel.alloppnet.speciation.AlloppNode;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.tree.SlidableTree;
import dr.evomodel.alloppnet.util.AlloppMisc;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import java.util.Stack;
import jebl.util.FixedBitSet;

public class AlloppLeggedTree
implements SlidableTree {
    private ALTNode[] altnodes;
    private int rootn;
    private int diphistlftleg;
    private int diphistrgtleg;

    public AlloppLeggedTree(Taxon[] taxonArray, double d) {
        int n = taxonArray.length;
        this.altnodes = new ALTNode[2 * n - 1];
        for (int i = 0; i < this.altnodes.length; ++i) {
            this.altnodes[i] = new ALTNode(i);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            this.altnodes[i].setTaxon(taxonArray[i].getId());
            this.altnodes[i].setHeight(0.0);
            arrayList.add(i);
        }
        double d2 = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            int n2 = arrayList.size();
            int n3 = MathUtils.nextInt(n2);
            Integer n4 = (Integer)arrayList.get(n3);
            arrayList.remove(n3);
            int n5 = MathUtils.nextInt(n2 - 1);
            Integer n6 = (Integer)arrayList.get(n5);
            arrayList.remove(n5);
            this.altnodes[n + i].addChildren(this.altnodes[n4], this.altnodes[n6]);
            this.altnodes[n + i].setHeight(d2 + this.randomnodeheight((double)n2 * d));
            d2 = this.altnodes[n + i].getHeight();
            arrayList.add(n + i);
        }
        this.diphistlftleg = -1;
        this.diphistrgtleg = -1;
        this.rootn = this.altnodes.length - 1;
    }

    public AlloppLeggedTree(AlloppLeggedTree alloppLeggedTree) {
        this.altnodes = new ALTNode[alloppLeggedTree.altnodes.length];
        for (int i = 0; i < this.altnodes.length; ++i) {
            this.altnodes[i] = new ALTNode(alloppLeggedTree.altnodes[i]);
        }
        this.rootn = alloppLeggedTree.rootn;
        this.diphistlftleg = alloppLeggedTree.diphistlftleg;
        this.diphistrgtleg = alloppLeggedTree.diphistrgtleg;
    }

    public AlloppLeggedTree(AlloppLeggedTree alloppLeggedTree, AlloppLeggedTree alloppLeggedTree2, double d) {
        this.altnodes = new ALTNode[1 + alloppLeggedTree.altnodes.length + alloppLeggedTree2.altnodes.length];
        this.diphistlftleg = alloppLeggedTree2.diphistlftleg;
        this.diphistrgtleg = alloppLeggedTree2.diphistrgtleg;
        int n = this.copySubtree(0, (ALTNode)alloppLeggedTree.getSlidableRoot());
        int n2 = n - 1;
        n = this.copySubtree(n, (ALTNode)alloppLeggedTree2.getSlidableRoot());
        int n3 = n - 1;
        assert (n == this.altnodes.length - 1);
        this.altnodes[n] = new ALTNode(n);
        this.altnodes[n].addChildren(this.altnodes[n2], this.altnodes[n3]);
        this.altnodes[n].setHeight(d);
        this.rootn = n;
    }

    public AlloppLeggedTree(AlloppLeggedTree alloppLeggedTree, AlloppNode alloppNode) {
        int n;
        ALTNode aLTNode = (ALTNode)alloppNode;
        int n2 = alloppLeggedTree.noftipsSubtree(aLTNode);
        this.altnodes = new ALTNode[2 * n2 - 1];
        for (n = 0; n < this.altnodes.length; ++n) {
            this.altnodes[n] = new ALTNode(n);
        }
        n = this.copySubtree(0, aLTNode);
        this.rootn = n - 1;
    }

    public AlloppLeggedTree(Taxon[] taxonArray) {
        int n;
        int n2 = taxonArray.length;
        assert (n2 <= 4);
        int n3 = 2 * n2 - 1;
        this.altnodes = new ALTNode[n3];
        for (n = 0; n < n3; ++n) {
            this.altnodes[n] = new ALTNode(n);
        }
        for (n = 0; n < n2; ++n) {
            this.altnodes[n].setTaxon(taxonArray[n].getId());
            this.altnodes[n].setHeight(0.0);
        }
        if (n2 == 2) {
            this.altnodes[2].setHeight(1.0);
            this.altnodes[2].addChildren(this.altnodes[0], this.altnodes[1]);
        }
        if (n2 == 3) {
            this.altnodes[3].setHeight(this.altnodes[0].getHeight() + 1.0);
            this.altnodes[3].addChildren(this.altnodes[0], this.altnodes[1]);
            this.altnodes[4].setHeight(this.altnodes[3].getHeight() + 1.0);
            this.altnodes[4].addChildren(this.altnodes[2], this.altnodes[3]);
        }
        if (n2 == 4) {
            this.altnodes[4].setHeight(this.altnodes[0].getHeight() + 1.0);
            this.altnodes[4].addChildren(this.altnodes[0], this.altnodes[1]);
            this.altnodes[5].setHeight(this.altnodes[4].getHeight() + 1.0);
            this.altnodes[5].addChildren(this.altnodes[2], this.altnodes[4]);
            this.altnodes[6].setHeight(this.altnodes[5].getHeight() + 1.0);
            this.altnodes[6].addChildren(this.altnodes[3], this.altnodes[5]);
        }
        this.rootn = this.altnodes.length - 1;
    }

    @Override
    public NodeRef getSlidableRoot() {
        assert (this.altnodes[this.rootn].anc < 0);
        return this.altnodes[this.rootn];
    }

    @Override
    public void replaceSlidableRoot(NodeRef nodeRef) {
        this.rootn = nodeRef.getNumber();
        this.altnodes[this.rootn].anc = -1;
    }

    @Override
    public int getSlidableNodeCount() {
        return this.altnodes.length;
    }

    @Override
    public double getSlidableNodeHeight(NodeRef nodeRef) {
        return this.altnodes[nodeRef.getNumber()].getHeight();
    }

    @Override
    public Taxon getSlidableNodeTaxon(NodeRef nodeRef) {
        return this.altnodes[nodeRef.getNumber()].getTaxon();
    }

    @Override
    public void setSlidableNodeHeight(NodeRef nodeRef, double d) {
        this.altnodes[nodeRef.getNumber()].height = d;
    }

    @Override
    public boolean isExternalSlidable(NodeRef nodeRef) {
        return this.altnodes[nodeRef.getNumber()].lft < 0;
    }

    @Override
    public NodeRef getSlidableChild(NodeRef nodeRef, int n) {
        int n2 = nodeRef.getNumber();
        return n == 0 ? this.altnodes[this.altnodes[n2].lft] : this.altnodes[this.altnodes[n2].rgt];
    }

    @Override
    public void replaceSlidableChildren(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        int n = nodeRef.getNumber();
        int n2 = nodeRef2.getNumber();
        int n3 = nodeRef3.getNumber();
        assert (this.altnodes[n].lft >= 0);
        this.altnodes[n].lft = n2;
        this.altnodes[n].rgt = n3;
        this.altnodes[n2].anc = this.altnodes[n].nodeNumber;
        this.altnodes[n3].anc = this.altnodes[n].nodeNumber;
    }

    String asText(int n) {
        String string = "Tetraploid tree " + String.valueOf(n) + "     height" + System.getProperty("line.separator");
        String string2 = "";
        Stack<Integer> stack = new Stack<Integer>();
        return string + AlloppNode.Abstract.subtreeAsText(this.altnodes[this.rootn], string2, stack, 0, "");
    }

    boolean leggedtreeOK() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.altnodes.length; ++n3) {
            if (this.altnodes[n3].anc >= 0) continue;
            ++n4;
        }
        if (n4 != 1) {
            return false;
        }
        for (n3 = 0; n3 < this.altnodes.length; ++n3) {
            n2 = 0;
            for (n = 0; n < this.altnodes.length; ++n) {
                if (this.altnodes[n].lft == n3) {
                    ++n2;
                }
                if (this.altnodes[n].rgt != n3) continue;
                ++n2;
            }
            if (this.altnodes[n3].anc < 0 && n2 != 0) {
                return false;
            }
            if (this.altnodes[n3].anc < 0 || n2 == 1) continue;
            return false;
        }
        for (n3 = 0; n3 < this.altnodes.length; ++n3) {
            if (this.altnodes[n3].getNumber() == n3) continue;
            return false;
        }
        for (n3 = 0; n3 < this.altnodes.length; ++n3) {
            if (this.altnodes[n3].lft >= 0) {
                if (this.altnodes[n3].rgt < 0) {
                    return false;
                }
                n2 = this.altnodes[n3].lft;
                n = this.altnodes[n3].rgt;
                if (this.altnodes[n2].anc != n3) {
                    return false;
                }
                if (this.altnodes[n].anc != n3) {
                    return false;
                }
                if (this.altnodes[n3].height <= this.altnodes[n2].height) {
                    return false;
                }
                if (!(this.altnodes[n3].height <= this.altnodes[n].height)) continue;
                return false;
            }
            if (this.altnodes[n3].height == 0.0) continue;
            return false;
        }
        return this.altnodes[this.rootn].anc < 0;
    }

    public int scaleAllHeights(double d) {
        int n = 0;
        for (int i = 0; i < this.altnodes.length; ++i) {
            if (this.altnodes[i].nofChildren() <= 0) continue;
            this.altnodes[i].height *= d;
            ++n;
        }
        return n;
    }

    public ArrayList<Taxon> getSpeciesTaxons() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        for (int i = 0; i < this.altnodes.length; ++i) {
            if (this.altnodes[i].nofChildren() != 0) continue;
            Taxon taxon = this.altnodes[i].getTaxon();
            arrayList.add(taxon);
        }
        assert (arrayList.size() == this.getExternalNodeCount());
        return arrayList;
    }

    public void fillinTipUnions(AlloppSpeciesBindings alloppSpeciesBindings, int n) {
        for (int i = 0; i < this.altnodes.length; ++i) {
            if (this.altnodes[i].nofChildren() != 0) continue;
            this.altnodes[i].setUnion(alloppSpeciesBindings.taxonseqToTipUnion(this.altnodes[i].taxon, n));
        }
    }

    public double getRootHeight() {
        return this.altnodes[this.rootn].height;
    }

    public int getExternalNodeCount() {
        return (this.altnodes.length + 1) / 2;
    }

    public int getInternalNodeCount() {
        return (this.altnodes.length - 1) / 2;
    }

    public void collectInternalHeights(ArrayList<Double> arrayList) {
        for (int i = 0; i < this.altnodes.length; ++i) {
            if (this.altnodes[i].nofChildren() <= 0) continue;
            arrayList.add(this.altnodes[i].height);
        }
    }

    public void setDiphistLftLeg(int n) {
        this.diphistlftleg = n;
    }

    public void setDiphistRgtLeg(int n) {
        this.diphistrgtleg = n;
    }

    public int getDiphistLftLeg() {
        return this.diphistlftleg;
    }

    public int getDiphistRgtLeg() {
        return this.diphistrgtleg;
    }

    private int copySubtree(int n, ALTNode aLTNode) {
        if (aLTNode.nofChildren() == 0) {
            this.altnodes[n] = new ALTNode(n, aLTNode);
            ++n;
        } else {
            n = this.copySubtree(n, (ALTNode)aLTNode.getChild(0));
            int n2 = n - 1;
            n = this.copySubtree(n, (ALTNode)aLTNode.getChild(1));
            int n3 = n - 1;
            this.altnodes[n] = new ALTNode(n, aLTNode);
            this.altnodes[n].anc = -1;
            this.altnodes[n].nodeNumber = n;
            this.altnodes[n].addChildren(this.altnodes[n2], this.altnodes[n3]);
            ++n;
        }
        return n;
    }

    private int noftipsSubtree(ALTNode aLTNode) {
        int n = 0;
        if (aLTNode.lft >= 0) {
            int n2 = this.noftipsSubtree(this.altnodes[aLTNode.lft]);
            int n3 = this.noftipsSubtree(this.altnodes[aLTNode.rgt]);
            n = n2 + n3;
        } else {
            n = 1;
        }
        return n;
    }

    private double randomnodeheight(double d) {
        return MathUtils.nextExponential(d) + 1.0E-6 / d;
    }

    private class ALTNode
    extends AlloppNode.Abstract
    implements AlloppNode,
    NodeRef {
        private int anc;
        private int lft;
        private int rgt;
        private double height;
        private Taxon taxon;
        private FixedBitSet union;
        private int nodeNumber;

        ALTNode(int n) {
            this.anc = -1;
            this.lft = -1;
            this.rgt = -1;
            this.height = -1.0;
            this.taxon = new Taxon("");
            this.union = null;
            this.nodeNumber = n;
        }

        public ALTNode(ALTNode aLTNode) {
            this.anc = aLTNode.anc;
            this.lft = aLTNode.lft;
            this.rgt = aLTNode.rgt;
            this.nodeNumber = aLTNode.nodeNumber;
            this.copyNonTopologyFields(aLTNode);
        }

        public ALTNode(int n, ALTNode aLTNode) {
            this.anc = -1;
            this.lft = -1;
            this.rgt = -1;
            this.nodeNumber = n;
            this.copyNonTopologyFields(aLTNode);
        }

        private void copyNonTopologyFields(ALTNode aLTNode) {
            this.height = aLTNode.height;
            this.taxon = new Taxon(aLTNode.taxon.getId());
            this.union = aLTNode.union == null ? null : new FixedBitSet(aLTNode.union);
        }

        @Override
        public AlloppNode getChild(int n) {
            return n == 0 ? AlloppLeggedTree.this.altnodes[this.lft] : AlloppLeggedTree.this.altnodes[this.rgt];
        }

        @Override
        public AlloppNode getAnc() {
            return AlloppLeggedTree.this.altnodes[this.anc];
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public Taxon getTaxon() {
            return this.taxon;
        }

        @Override
        public FixedBitSet getUnion() {
            return this.union;
        }

        @Override
        public void setChild(int n, AlloppNode alloppNode) {
            int n2 = ((ALTNode)alloppNode).nodeNumber;
            if (n == 0) {
                this.lft = n2;
            } else {
                this.rgt = n2;
            }
        }

        @Override
        public void setAnc(AlloppNode alloppNode) {
            this.anc = ((ALTNode)alloppNode).nodeNumber;
        }

        @Override
        public void setTaxon(String string) {
            this.taxon = new Taxon(string);
        }

        @Override
        public void setHeight(double d) {
            this.height = d;
        }

        @Override
        public void setUnion(FixedBitSet fixedBitSet) {
            this.union = fixedBitSet;
        }

        @Override
        public void addChildren(AlloppNode alloppNode, AlloppNode alloppNode2) {
            this.lft = ((ALTNode)alloppNode).nodeNumber;
            ((AlloppLeggedTree)AlloppLeggedTree.this).altnodes[this.lft].anc = this.nodeNumber;
            this.rgt = ((ALTNode)alloppNode2).nodeNumber;
            ((AlloppLeggedTree)AlloppLeggedTree.this).altnodes[this.rgt].anc = this.nodeNumber;
        }

        @Override
        public String asText(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            Formatter formatter = new Formatter(stringBuilder, Locale.US);
            if (this.lft < 0) {
                formatter.format("%s ", this.taxon.getId());
            } else {
                formatter.format("%s ", "+");
            }
            while (stringBuilder.length() < 20 - n) {
                formatter.format("%s", " ");
            }
            formatter.format("%s ", AlloppMisc.nonnegIn8Chars(this.height));
            return stringBuilder.toString();
        }

        @Override
        public int nofChildren() {
            return this.lft < 0 ? 0 : 2;
        }

        @Override
        public int getNumber() {
            return this.nodeNumber;
        }

        @Override
        public void setNumber(int n) {
            this.nodeNumber = n;
        }
    }
}

