/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;

public class TwoStateCovarion
extends DataType {
    public static final String DESCRIPTION = "twoStateCovarion";
    public static final int TYPE = 5;
    public static final TwoStateCovarion INSTANCE = new TwoStateCovarion();

    private TwoStateCovarion() {
        this.stateCount = 4;
        this.ambiguousStateCount = 8;
    }

    @Override
    public char[] getValidChars() {
        return null;
    }

    @Override
    public int getState(char c) {
        switch (c) {
            case 'a': {
                return 0;
            }
            case 'b': {
                return 1;
            }
            case 'c': {
                return 2;
            }
            case 'd': {
                return 3;
            }
            case '0': {
                return 4;
            }
            case '1': {
                return 5;
            }
            case '?': {
                return this.getUnknownState();
            }
            case '-': {
                return this.getGapState();
            }
        }
        throw new IllegalArgumentException("Character " + c + " not recognised in two-state covarion datatype!");
    }

    @Override
    public char getChar(int n) {
        switch (n) {
            case 0: {
                return 'a';
            }
            case 1: {
                return 'b';
            }
            case 2: {
                return 'c';
            }
            case 3: {
                return 'd';
            }
            case 4: {
                return '0';
            }
            case 5: {
                return '1';
            }
            case 6: {
                return '?';
            }
            case 7: {
                return '-';
            }
        }
        throw new IllegalArgumentException("State " + n + " not recognised in two-state covarion datatype!");
    }

    @Override
    public int[] getStates(int n) {
        if (n == 4 || n == 5) {
            int[] nArray = new int[]{n % 2, n % 2 + 2};
            return nArray;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean[] getStateSet(int n) {
        int n2;
        boolean[] blArray = new boolean[this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            blArray[n2] = false;
        }
        if (!this.isAmbiguousState(n)) {
            blArray[n] = true;
        } else if (n == 4 || n == 5) {
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                if (n2 % 2 != n % 2) continue;
                blArray[n2] = true;
            }
        } else {
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                blArray[n2] = true;
            }
        }
        return blArray;
    }

    @Override
    public int getUnknownState() {
        return this.stateCount + 2;
    }

    @Override
    public int getGapState() {
        return this.stateCount + 3;
    }

    @Override
    public boolean isAmbiguousChar(char c) {
        return this.isAmbiguousState(this.getState(c));
    }

    @Override
    public boolean isUnknownChar(char c) {
        return this.isUnknownState(this.getState(c));
    }

    @Override
    public boolean isGapChar(char c) {
        return this.isGapState(this.getState(c));
    }

    @Override
    public boolean isAmbiguousState(int n) {
        return n >= 4;
    }

    @Override
    public boolean isUnknownState(int n) {
        return n == this.getUnknownState();
    }

    @Override
    public boolean isGapState(int n) {
        return n == this.getGapState();
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getType() {
        return 5;
    }
}

