/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.advanced.math;

import jdplus.toolkit.base.api.advanced.algebra.Ring;
import jdplus.toolkit.base.api.advanced.math.PolynomialsLoader;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.design.InterchangeableProcessor;
import jdplus.toolkit.base.api.math.Complex;
import lombok.Generated;

public final class Polynomials {
    private static final PolynomialsLoader.Processor PROCESSOR = new PolynomialsLoader.Processor();

    public static void setProcessor(Processor processor) {
        PROCESSOR.set(processor);
    }

    public static Processor getProcessor() {
        return PROCESSOR.get();
    }

    public static Complex[] rootsOf(DoubleSeq polynomial, Solver solver) {
        return PROCESSOR.get().rootsOf(polynomial, solver);
    }

    public static double evaluate(DoubleSeq polynomial, double x) {
        return PROCESSOR.get().evaluate(polynomial, x);
    }

    public static Complex evaluate(DoubleSeq polynomial, Complex x) {
        return PROCESSOR.get().evaluate(polynomial, x);
    }

    @Generated
    private Polynomials() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @InterchangeableProcessor
    public static interface Processor
    extends Ring<DoubleSeq> {
        public Complex[] rootsOf(DoubleSeq var1, Solver var2);

        public double evaluate(DoubleSeq var1, double var2);

        public Complex evaluate(DoubleSeq var1, Complex var2);
    }

    public static enum Solver {
        Default,
        MullerNewton,
        EigenValues,
        FastEigenValues,
        Robust;

    }
}

