/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.multivariate;

import java.util.ArrayList;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.ssf.IPredictionErrorDecomposition;
import jdplus.toolkit.base.core.ssf.State;
import jdplus.toolkit.base.core.ssf.StateInfo;
import jdplus.toolkit.base.core.ssf.UpdateInformation;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateFilteringResults;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsf;
import jdplus.toolkit.base.core.ssf.multivariate.IMultivariateSsfData;
import jdplus.toolkit.base.core.ssf.multivariate.MultivariateUpdateInformation;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;
import jdplus.toolkit.base.core.stats.likelihood.ResidualsCumulator;

public class MultivariateUpdates
implements IPredictionErrorDecomposition,
IMultivariateFilteringResults {
    private final ResidualsCumulator cumulator = new ResidualsCumulator();
    private List<MultivariateUpdateInformation> infos;

    @Override
    public void open(IMultivariateSsf ssf, IMultivariateSsfData data) {
        this.infos = new ArrayList<MultivariateUpdateInformation>(data.getObsCount());
        this.cumulator.clear();
    }

    @Override
    public void close() {
    }

    public int size() {
        return this.infos.size();
    }

    public MultivariateUpdateInformation get(int idx) {
        return this.infos.get(idx);
    }

    @Override
    public void save(int t, MultivariateUpdateInformation pe) {
        if (pe == null) {
            return;
        }
        this.infos.set(t, pe);
        DataBlock diag = pe.getR().diagonal();
        DoubleSeq err = pe.getE();
        UpdateInformation.Status[] status = pe.getStatus();
        int iv = 0;
        for (int i = 0; i < status.length; ++i) {
            double r;
            if (status[i] == UpdateInformation.Status.MISSING) continue;
            if (status[i] == UpdateInformation.Status.OBSERVATION && (r = diag.get(iv)) != 0.0) {
                this.cumulator.addStd(err.get(iv), r);
            }
            ++iv;
        }
    }

    @Override
    public void save(int pos, State state, StateInfo info) {
    }

    @Override
    public Likelihood likelihood(boolean scalingfactor) {
        return Likelihood.builder(this.cumulator.getObsCount()).scalingFactor(scalingfactor).ssqErr(this.cumulator.getSsqErr()).logDeterminant(this.cumulator.getLogDeterminant()).build();
    }
}

