## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval = FALSE-------------------------------------------------------------
#  library(MMGFM)

## ----eval = FALSE-------------------------------------------------------------
#  source("https://raw.githubusercontent.com/feiyoung/MMGFM/refs/heads/main/simu_code/definedFunc.R")

## ----eval = FALSE-------------------------------------------------------------
#  q <- 3
#  qsvec  <- rep(2,3)
#  sigma_eps <- 1
#  datlist <- gendata_MM(seed = 1,  nvec = c(300, 200, 100),
#                          pveclist = list('gaussian'=c(100, 200),'poisson'=c(50, 150, 200)),
#                          q = q,  d= 3,qs = qsvec,  rho = c(3, 2), rho_z=0.5,
#                          sigmavec=c(0, 0),  sigma_eps=sigma_eps)
#  XList <- datlist$XList
#  max(unlist(XList))
#  print(str(XList))
#  ZList <- datlist$ZList # covariates
#  print(head(ZList[[1]]))
#  tauList <- datlist$tauList # offset term
#  numvarmat <- datlist$numvarmat

## ----eval = FALSE-------------------------------------------------------------
#  system.time({
#    tic <- proc.time()
#    reslist <- MMGFM(XList, ZList=ZList, numvarmat, q=q, qsvec = qsvec, init='MSFRVI')
#    toc <- proc.time()
#    time_MMGFM <- toc[3] - tic[3]
#  })

## ----eval = FALSE-------------------------------------------------------------
#  library(ggplot2)
#  dat_iter <- data.frame(iter=1:length(reslist$ELBO_seq), ELBO=reslist$ELBO_seq)
#  ggplot(data=dat_iter, aes(x=iter, y=ELBO)) + geom_line() + geom_point() + theme_bw(base_size = 20)

## ----eval = FALSE-------------------------------------------------------------
#  
#  methodNames <- c("MMGFM", "GFM", "MRRR", "MSFR")
#  n_methods <- length(methodNames)
#  metricList <- list(F_tr = rep(NA, n_methods),
#                     H_tr = rep(NA,  n_methods),
#                     V_tr = rep(NA,  n_methods),
#                     A_tr = rep(NA, n_methods),
#                     B_tr = rep(NA,  n_methods),
#                     beta_norm=rep(NA,  n_methods),
#                     time = rep(NA,  n_methods))
#  for(ii in seq_along(metricList)) names(metricList[[ii]]) <- methodNames
#  metricList$F_tr[1] <- meanTr(reslist$hF, datlist$F0List)
#  metricList$H_tr[1] <-meanTr(reslist$hH, datlist$H0List)
#  metricList$V_tr[1] <-meanTr(lapply(reslist$hv, function(x) Reduce(cbind,x) ), datlist$VList)
#  metricList$A_tr[1] <-metric_mean(AList=reslist$hA, datlist$A0List, align='unaligned', numvarmat = numvarmat)
#  metricList$B_tr[1] <- mean(ms_metric_mean(reslist$hB, datlist$B0List, align='unaligned', numvarmat = numvarmat))
#  metricList$beta_norm[1] <-normvec(Reduce(cbind, reslist$hbeta)- Reduce(cbind,datlist$betaList))
#  metricList$time[1] <- reslist$time.use
#  

## ----eval = FALSE-------------------------------------------------------------
#  options(warn = -1)
#  res_gfm <- gfm_run(XList, numvarmat, q=q)
#  metricList$F_tr[2] <- meanTr(res_gfm$hF, datlist$F0List)
#  metricList$A_tr[2] <-metric_mean(AList=res_gfm$hA, datlist$A0List, align='unaligned', numvarmat = numvarmat)
#  metricList$time[2] <- res_gfm$time.use

## ----eval = FALSE-------------------------------------------------------------
#  res_mrrr <- mrrr_run(XList, ZList, numvarmat, q, truncflag=TRUE, trunc=500)
#  metricList$F_tr[3] <- meanTr(res_mrrr$hF, datlist$F0List)
#  metricList$A_tr[3] <- metric_mean(AList=res_mrrr$hA, datlist$A0List, align='unaligned', numvarmat = numvarmat)
#  metricList$beta_norm[3] <-normvec(res_mrrr$hbeta - Reduce(cbind,datlist$betaList))
#  metricList$time[3] <- res_mrrr$time.use

## ----eval = FALSE-------------------------------------------------------------
#  source("https://raw.githubusercontent.com/feiyoung/MMGFM/refs/heads/main/simu_code/MSFR_main_R_MSFR_V1.R")
#  ## To produce results in limited time, here we set maxIter=5 Even Set maxIter=1e4, the result is also not good.
#  res_msfr <- MSFR_run(XList, ZList, numvarmat, q, qs=qsvec, maxIter=5, load.source=TRUE, log.transform=TRUE)
#  metricList$F_tr[4] <- meanTr(res_msfr$hF, datlist$F0List)
#  metricList$H_tr[4] <- meanTr(res_msfr$hH, datlist$H0List)
#  metricList$A_tr[4] <- metric_mean(AList=res_msfr$hA, datlist$A0List, align='unaligned', numvarmat = numvarmat)
#  metricList$B_tr[4] <- mean(ms_metric_mean(res_msfr$hB, datlist$B0List, align='unaligned', numvarmat = numvarmat))
#  metricList$beta_norm[4] <- normvec(t(res_msfr$hbeta)- Reduce(cbind,datlist$betaList))
#  metricList$time[4] <- res_msfr$time.use

## ----eval = FALSE-------------------------------------------------------------
#  mat.metric <- round(Reduce(rbind, metricList),3)
#  row.names(mat.metric) <- names(metricList)
#  
#  dat_metric <- as.data.frame(mat.metric)
#  DT::datatable(dat_metric)

## ----eval = FALSE-------------------------------------------------------------
#  
#  qqlist <- selectFac.MMGFM(XList, ZList=ZList, numvarmat, q.max=6, qsvec.max = rep(4,3))
#  str(qqlist)

## ----eval = FALSE-------------------------------------------------------------
#  print(c('true q'= q, ' est. q'=qqlist$q))
#  cat('est. qs=',qqlist$qs.vec, '\n')
#  cat('true qs=', qsvec, '\n')

## -----------------------------------------------------------------------------
sessionInfo()

