/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.SymmTridiagMatrix;

public class SPDTridiagMatrix
extends SymmTridiagMatrix {
    public SPDTridiagMatrix(int n) {
        super(n);
    }

    public SPDTridiagMatrix(Matrix A) {
        super(A);
    }

    public SPDTridiagMatrix(Matrix A, boolean deep) {
        super(A, deep);
    }

    public SPDTridiagMatrix copy() {
        return new SPDTridiagMatrix(this);
    }

    public Matrix solve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int info = Interface.lapack().ptsv(this.numRows, X.numColumns(), (double[])this.diag.clone(), (double[])this.offDiag.clone(), Xd);
        if (info > 0) {
            throw new MatrixNotSPDException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }
}

