/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11.filter;

import jdplus.toolkit.base.core.math.linearfilters.LinearFilterException;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.core.x11.filter.X11FilterFactory;

public final class X11TrendCycleFilterFactory {
    public static SymmetricFilter defaultHendersonFilterForFrequency(int frequency) {
        int len = frequency;
        if (frequency % 2 == 0) {
            ++len;
        }
        return X11TrendCycleFilterFactory.makeHendersonFilter(len);
    }

    public static SymmetricFilter makeHendersonFilter(int length) {
        if (length % 2 == 0) {
            throw new LinearFilterException("Invalid length for Henderson filter. Should be odd");
        }
        int m = length / 2;
        double[] c = new double[m + 1];
        int n = m + 2;
        double n2 = n * n;
        for (int i = 0; i < m + 1; ++i) {
            double ii = (i - m) * (i - m);
            double up = 315.0 * (n2 - (double)(n * 2) + 1.0 - ii);
            up *= n2 - ii;
            up *= n2 + (double)(n * 2) + 1.0 - ii;
            double down = n * 8;
            down *= n2 - 1.0;
            down *= n2 * 4.0 - 1.0;
            down *= n2 * 4.0 - 9.0;
            c[m - i] = (up *= n2 * 3.0 - 16.0 - ii * 11.0) / (down *= n2 * 4.0 - 25.0);
        }
        return SymmetricFilter.ofInternal((double[])c);
    }

    public static SymmetricFilter makeTrendFilter(int frequency) {
        if (frequency % 2 == 0) {
            return X11FilterFactory.makeSymmetricFilter(2, frequency);
        }
        return X11FilterFactory.makeSymmetricFilter(frequency);
    }
}

