/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import jdplus.toolkit.base.api.ssf.sts.SeasonalModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearsystem.LinearSystemSolver;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.GeneralMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class SeasonalComponent {
    private static FastMatrix VTS2;
    private static FastMatrix VTS3;
    private static FastMatrix VTS4;
    private static FastMatrix VTS6;
    private static FastMatrix VTS12;
    private static FastMatrix LVTS2;
    private static FastMatrix LVTS3;
    private static FastMatrix LVTS4;
    private static FastMatrix LVTS6;
    private static FastMatrix LVTS12;
    private static FastMatrix LHS2;
    private static FastMatrix LHS3;
    private static FastMatrix LHS4;
    private static FastMatrix LHS6;
    private static FastMatrix LHS12;

    private static FastMatrix tsvar(int freq) {
        int n = freq - 1;
        FastMatrix M = FastMatrix.make(n, freq);
        M.diagonal().set(1.0);
        M.column(n).set(-1.0);
        FastMatrix O = SymmetricMatrix.XXt(M);
        LinearSystemSolver.robustSolver().solve(O, M);
        FastMatrix H = FastMatrix.make(freq, n);
        for (int i = 0; i < freq; ++i) {
            double z = Math.PI * 2 * (double)(i + 1) / (double)freq;
            for (int j = 0; j < n / 2; ++j) {
                H.set(i, 2 * j, Math.cos((double)(j + 1) * z));
                H.set(i, 2 * j + 1, Math.sin((double)(j + 1) * z));
            }
            if (n % 2 != 1) continue;
            H.set(i, n - 1, Math.cos((double)(freq / 2) * z));
        }
        FastMatrix QH = GeneralMatrix.AB(M, H);
        FastMatrix Z = SymmetricMatrix.XXt(QH);
        Z.apply(x -> Math.abs(x) < 1.0E-12 ? 0.0 : x);
        return Z;
    }

    private static synchronized FastMatrix tsVar(int freq) {
        switch (freq) {
            case 12: {
                if (VTS12 == null) {
                    VTS12 = SeasonalComponent.tsvar(12);
                }
                return VTS12.deepClone();
            }
            case 4: {
                if (VTS4 == null) {
                    VTS4 = SeasonalComponent.tsvar(4);
                }
                return VTS4.deepClone();
            }
            case 2: {
                if (VTS2 == null) {
                    VTS2 = SeasonalComponent.tsvar(2);
                }
                return VTS2.deepClone();
            }
            case 3: {
                if (VTS3 == null) {
                    VTS3 = SeasonalComponent.tsvar(3);
                }
                return VTS3.deepClone();
            }
            case 6: {
                if (VTS6 == null) {
                    VTS6 = SeasonalComponent.tsvar(6);
                }
                return VTS6.deepClone();
            }
        }
        return SeasonalComponent.tsvar(freq);
    }

    private static FastMatrix hsvar(int freq) {
        FastMatrix m = FastMatrix.square(freq - 1);
        m.set(-1.0 / (double)freq);
        m.diagonal().add(1.0);
        return m;
    }

    private static synchronized FastMatrix hslVar(int freq) {
        switch (freq) {
            case 12: {
                if (LHS12 == null) {
                    LHS12 = SeasonalComponent.hsvar(12);
                    SymmetricMatrix.lcholesky(LHS12);
                }
                return LHS12.deepClone();
            }
            case 4: {
                if (LHS4 == null) {
                    LHS4 = SeasonalComponent.hsvar(4);
                    SymmetricMatrix.lcholesky(LHS4);
                }
                return LHS4.deepClone();
            }
            case 2: {
                if (LHS2 == null) {
                    LHS2 = SeasonalComponent.hsvar(2);
                    SymmetricMatrix.lcholesky(LHS2);
                }
                return LHS2.deepClone();
            }
            case 3: {
                if (LHS3 == null) {
                    LHS3 = SeasonalComponent.hsvar(3);
                    SymmetricMatrix.lcholesky(LHS3);
                }
                return LHS3.deepClone();
            }
            case 6: {
                if (LHS6 == null) {
                    LHS6 = SeasonalComponent.hsvar(6);
                    SymmetricMatrix.lcholesky(LHS6);
                }
                return LHS6.deepClone();
            }
        }
        FastMatrix lhs = SeasonalComponent.hsvar(freq);
        SymmetricMatrix.lcholesky(lhs);
        return lhs;
    }

    public static FastMatrix tsVar(SeasonalModel seasModel, int freq) {
        if (seasModel == SeasonalModel.Trigonometric) {
            return SeasonalComponent.tsVar(freq);
        }
        int n = freq - 1;
        FastMatrix Q = FastMatrix.square(n);
        if (null != seasModel) {
            switch (seasModel) {
                case Dummy: {
                    Q.set(n - 1, n - 1, 1.0);
                    break;
                }
                case Crude: {
                    Q.set(1.0);
                    break;
                }
                case HarrisonStevens: {
                    double v = 1.0 / (double)freq;
                    Q.set(-v);
                    Q.diagonal().add(1.0);
                    break;
                }
            }
        }
        return Q;
    }

    private static synchronized FastMatrix tslVar(int freq) {
        switch (freq) {
            case 12: {
                if (LVTS12 == null) {
                    LVTS12 = SeasonalComponent.tsvar(12);
                    SymmetricMatrix.lcholesky(LVTS12);
                    LVTS12.apply(x -> Math.abs(x) < 1.0E-12 ? 0.0 : x);
                }
                return LVTS12.deepClone();
            }
            case 4: {
                if (LVTS4 == null) {
                    LVTS4 = SeasonalComponent.tsvar(4);
                    LVTS4.apply(x -> Math.abs(x) < 1.0E-12 ? 0.0 : x);
                    SymmetricMatrix.lcholesky(LVTS4);
                }
                return LVTS4.deepClone();
            }
            case 2: {
                if (LVTS2 == null) {
                    LVTS2 = SeasonalComponent.tsvar(2);
                    LVTS2.apply(x -> Math.abs(x) < 1.0E-12 ? 0.0 : x);
                    SymmetricMatrix.lcholesky(LVTS2);
                }
                return LVTS2.deepClone();
            }
            case 3: {
                if (LVTS3 == null) {
                    LVTS3 = SeasonalComponent.tsvar(3);
                    SymmetricMatrix.lcholesky(LVTS3);
                    LVTS3.apply(x -> Math.abs(x) < 1.0E-12 ? 0.0 : x);
                }
                return LVTS3.deepClone();
            }
            case 6: {
                if (LVTS6 == null) {
                    LVTS6 = SeasonalComponent.tsvar(6);
                    SymmetricMatrix.lcholesky(LVTS6);
                    LVTS6.apply(x -> Math.abs(x) < 1.0E-12 ? 0.0 : x);
                }
                return LVTS6.deepClone();
            }
        }
        FastMatrix var = SeasonalComponent.tsvar(freq);
        SymmetricMatrix.lcholesky(var);
        var.apply(x -> Math.abs(x) < 1.0E-12 ? 0.0 : x);
        return var;
    }

    public static FastMatrix tslVar(SeasonalModel seasModel, int freq) {
        switch (seasModel) {
            case Trigonometric: {
                return SeasonalComponent.tslVar(freq);
            }
            case HarrisonStevens: {
                return SeasonalComponent.hslVar(freq);
            }
        }
        int n = freq - 1;
        FastMatrix Q = FastMatrix.square(n);
        switch (seasModel) {
            case Dummy: {
                Q.set(n - 1, n - 1, 1.0);
                break;
            }
            case Crude: {
                Q.set(1.0);
                break;
            }
        }
        return Q;
    }

    public static StateComponent of(SeasonalModel model, int period, double seasVar) {
        SeasonalModel cmodel = seasVar == 0.0 ? SeasonalModel.Fixed : model;
        Data data = new Data(cmodel, seasVar, period);
        return new StateComponent(new Initialization(data), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading() {
        return Loading.fromPosition(0);
    }

    public static StateComponent harrisonStevens(int period, double v) {
        HarrisonStevensData data = new HarrisonStevensData(period, v);
        return new StateComponent(new HarrisonStevensInitialization(data), new HarrisonStevensDynamics(data));
    }

    public static ISsfLoading harrisonStevensLoading(int period) {
        return Loading.circular(period);
    }

    public static StateComponent harrisonStevens(double[] var) {
        HarrisonStevensData data = new HarrisonStevensData(var);
        return new StateComponent(new HarrisonStevensInitialization(data), new HarrisonStevensDynamics(data));
    }

    @Generated
    private SeasonalComponent() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Data {
        private final SeasonalModel seasModel;
        private final double seasVar;
        private final int period;
        private final FastMatrix tsvar;
        private final FastMatrix lvar;

        Data(SeasonalModel model, double seasVar, int period) {
            this.seasVar = seasVar;
            this.seasModel = model;
            this.period = period;
            if (seasVar > 0.0) {
                this.tsvar = SeasonalComponent.tsVar(this.seasModel, period);
                this.tsvar.mul(seasVar);
                if (model != SeasonalModel.Crude && model != SeasonalModel.Dummy) {
                    this.lvar = SeasonalComponent.tslVar(this.seasModel, period);
                    this.lvar.mul(this.std());
                } else {
                    this.lvar = null;
                }
            } else {
                this.tsvar = null;
                this.lvar = null;
            }
        }

        final double std() {
            if (this.seasVar == 0.0 || this.seasVar == 1.0) {
                return this.seasVar;
            }
            return Math.sqrt(this.seasVar);
        }
    }

    static class Initialization
    implements ISsfInitialization {
        private final Data data;

        public Initialization(Data data) {
            this.data = data;
        }

        @Override
        public int getStateDim() {
            return this.data.period - 1;
        }

        @Override
        public boolean isDiffuse() {
            return this.data.seasVar >= 0.0;
        }

        @Override
        public int getDiffuseDim() {
            return this.data.period - 1;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            b.diagonal().set(1.0);
        }

        @Override
        public void Pi0(FastMatrix p) {
            p.diagonal().set(1.0);
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix p) {
            if (this.data.seasVar > 0.0) {
                if (this.data.seasModel == SeasonalModel.Dummy) {
                    p.set(0, 0, this.data.seasVar);
                } else {
                    p.copy(this.data.tsvar);
                }
            }
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        private final Data data;

        public Dynamics(Data data) {
            this.data = data;
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public int getInnovationsDim() {
            if (this.data.seasVar > 0.0) {
                if (this.data.seasModel == SeasonalModel.Dummy || this.data.seasModel == SeasonalModel.Crude) {
                    return 1;
                }
                return this.data.period - 1;
            }
            return 0;
        }

        @Override
        public void V(int pos, FastMatrix v) {
            if (this.data.seasVar > 0.0) {
                if (this.data.seasModel == SeasonalModel.Dummy) {
                    v.set(0, 0, this.data.seasVar);
                } else {
                    v.copy(this.data.tsvar);
                }
            }
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.data.seasModel != SeasonalModel.Fixed;
        }

        @Override
        public void S(int pos, FastMatrix s) {
            if (null != this.data.seasModel) {
                switch (this.data.seasModel) {
                    case Crude: {
                        s.set(this.data.std());
                        break;
                    }
                    case Dummy: {
                        s.set(this.data.period - 2, this.data.period - 2, this.data.std());
                        break;
                    }
                    default: {
                        s.copy(this.data.lvar);
                    }
                }
            }
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            switch (this.data.seasModel) {
                case Crude: {
                    x.add(this.data.std() * u.get(0));
                    break;
                }
                case Dummy: {
                    x.add(0, this.data.std() * u.get(0));
                    break;
                }
                default: {
                    x.addProduct(this.data.lvar.rowsIterator(), u);
                }
            }
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            switch (this.data.seasModel) {
                case Crude: {
                    xs.set(0, this.data.std() * x.sum());
                    break;
                }
                case Dummy: {
                    xs.set(0, this.data.std() * x.get(this.data.period - 2));
                    break;
                }
                default: {
                    xs.product(x, this.data.lvar.columnsIterator());
                }
            }
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            if (this.data.seasVar >= 0.0) {
                tr.row(this.data.period - 2).set(-1.0);
                tr.subDiagonal(1).set(1.0);
            }
        }

        @Override
        public void TX(int pos, DataBlock x) {
            x.fshiftAndNegSum();
        }

        @Override
        public void XT(int pos, DataBlock x) {
            int imax = this.data.period - 2;
            double xs = x.get(0);
            for (int i = 0; i < imax; ++i) {
                x.set(i, x.get(i + 1) - xs);
            }
            x.set(imax, -xs);
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            switch (this.data.seasModel) {
                case Fixed: {
                    return;
                }
                case Dummy: {
                    p.add(this.data.period - 2, this.data.period - 2, this.data.seasVar);
                    break;
                }
                case Crude: {
                    p.add(this.data.seasVar);
                    break;
                }
                default: {
                    p.add(this.data.tsvar);
                }
            }
        }
    }

    public static class HarrisonStevensData {
        private final int period;
        private final double[] var;
        private final FastMatrix V;

        public HarrisonStevensData(int period, double v) {
            this.period = period;
            this.var = null;
            this.V = FastMatrix.square(period - 1);
            this.V.set(-1.0 / (double)period);
            this.V.diagonal().add(1.0);
            this.V.mul(v);
        }

        public HarrisonStevensData(double[] var) {
            this.period = var.length;
            this.var = (double[])var.clone();
            DataBlock xvar = DataBlock.of(var);
            this.V = FastMatrix.square(this.period - 1);
            double mvar = xvar.sum() / (double)(this.period * this.period);
            double dp = 2.0 / (double)this.period;
            for (int i = 0; i < this.period - 1; ++i) {
                this.V.set(i, i, var[i] * (1.0 - dp) + mvar);
                for (int j = 0; j < i; ++j) {
                    this.V.set(i, j, mvar - (var[i] + var[j]) / (double)this.period);
                }
            }
            SymmetricMatrix.fromLower(this.V);
        }

        public double[] getVariances() {
            return this.var;
        }
    }

    public static class HarrisonStevensInitialization
    implements ISsfInitialization {
        private final HarrisonStevensData data;

        public HarrisonStevensInitialization(HarrisonStevensData data) {
            this.data = data;
        }

        @Override
        public int getStateDim() {
            return this.data.period - 1;
        }

        @Override
        public boolean isDiffuse() {
            return true;
        }

        @Override
        public int getDiffuseDim() {
            return this.data.period - 1;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            b.diagonal().set(1.0);
        }

        @Override
        public void Pi0(FastMatrix b) {
            b.diagonal().set(1.0);
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix p) {
            if (this.data.V != null) {
                p.copy(this.data.V);
            }
        }
    }

    public static class HarrisonStevensDynamics
    implements ISsfDynamics {
        private final HarrisonStevensData data;

        public HarrisonStevensDynamics(HarrisonStevensData data) {
            this.data = data;
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public int getInnovationsDim() {
            return this.data.period - 1;
        }

        @Override
        public void V(int pos, FastMatrix qm) {
            if (this.data.V != null) {
                qm.copy(this.data.V);
            }
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.data.V != null;
        }

        @Override
        public void S(int pos, FastMatrix s) {
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            tr.diagonal().set(1.0);
        }

        @Override
        public void TX(int pos, DataBlock x) {
        }

        @Override
        public void XT(int pos, DataBlock x) {
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.add(this.data.V);
        }
    }
}

