/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CodelistParser
implements Parser<Codelist> {
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String CODELIST = "Codelist";
    static final String CODE_ID = "Code";
    static final String ID = "id";
    static final String CODE_DESCRIPTION = "Name";
    static final String PARENT = "Parent";
    static final String REF = "Ref";
    static final String AGENCY = "agencyID";
    static final String VERSION = "version";

    @Override
    public Codelist parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        return CodelistParser.getCodeList(xMLEventReader, list);
    }

    public static Codelist getCodeList(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        String string = null;
        String string2 = null;
        String string3 = null;
        while (xMLEventReader.hasNext()) {
            StartElement startElement;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (!xMLEvent.isStartElement() || !CODELIST.equalsIgnoreCase((startElement = xMLEvent.asStartElement()).getName().getLocalPart())) continue;
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                if (attribute.getName().toString().equals(ID)) {
                    string = attribute.getValue();
                    continue;
                }
                if (attribute.getName().toString().equals(AGENCY)) {
                    string2 = attribute.getValue();
                    continue;
                }
                if (!attribute.getName().toString().equals(VERSION)) continue;
                string3 = attribute.getValue();
            }
            logger.finest("Got codelist: " + string);
            break;
        }
        return CodelistParser.getCodes(new SDMXReference(string, string2, string3), xMLEventReader, list);
    }

    public static Codelist getCodes(SDMXReference sDMXReference, XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        return CodelistParser.getCodes(sDMXReference, xMLEventReader, list, ID, CODE_DESCRIPTION);
    }

    public static Codelist getCodes(SDMXReference sDMXReference, XMLEventReader xMLEventReader, List<Locale.LanguageRange> list, String string, String string2) throws XMLStreamException, SdmxException {
        LinkedHashMap<String, LocalizedText> linkedHashMap = new LinkedHashMap<String, LocalizedText>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Codelist codelist = null;
        String string3 = null;
        LocalizedText localizedText = new LocalizedText(list);
        boolean bl = false;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Attribute attribute;
                Iterator<Attribute> iterator;
                object = xMLEvent.asStartElement();
                if (CODE_ID.equals(object.getName().getLocalPart())) {
                    localizedText = new LocalizedText(list);
                    string3 = null;
                    iterator = object.getAttributes();
                    while (iterator.hasNext()) {
                        attribute = iterator.next();
                        if (!string.equals(attribute.getName().getLocalPart())) continue;
                        string3 = attribute.getValue();
                    }
                } else if (string2.equals(object.getName().getLocalPart())) {
                    localizedText.setText((StartElement)object, xMLEventReader);
                } else if (PARENT.equals(object.getName().getLocalPart())) {
                    bl = true;
                } else if (bl && REF.equals(object.getName().getLocalPart())) {
                    iterator = object.getAttributes();
                    while (iterator.hasNext()) {
                        attribute = iterator.next();
                        if (!string.equals(attribute.getName().getLocalPart())) continue;
                        hashMap.put(string3, attribute.getValue());
                        logger.finest("PARENT: " + string3 + " = " + attribute.getValue());
                    }
                }
            }
            if (!xMLEvent.isEndElement()) continue;
            object = xMLEvent.asEndElement().getName().getLocalPart();
            if (CODE_ID.equals(object)) {
                if (string3 != null) {
                    logger.finest("Got code " + string3 + ", " + localizedText.getText());
                    linkedHashMap.put(string3, localizedText);
                    continue;
                }
                throw new SdmxXmlContentException("Error during Codelist Parsing. Invalid code id: " + string3);
            }
            if (PARENT.equals(object)) {
                bl = false;
                continue;
            }
            if (!CODELIST.equalsIgnoreCase((String)object)) continue;
            codelist = new Codelist(sDMXReference, linkedHashMap, hashMap);
            break;
        }
        return codelist;
    }
}

