
<!-- README.md is generated from README.Rmd. Please edit that file -->

# bayesDiagnostics

<!-- badges: start -->

<!-- badges: end -->

## Overview

`bayesDiagnostics` provides comprehensive tools for Bayesian model
diagnostics and comparison, addressing critical gaps in existing
Bayesian diagnostic tools.

### Key Features

- **Prior Sensitivity Analysis**: Assess posterior robustness to prior
  specification
- **Automated Posterior Predictive Checks**: Comprehensive diagnostic
  batteries
- **Advanced Model Comparison**: Beyond WAIC/LOO using stacking and
  cross-validation
- **Specialized Convergence Diagnostics**: For hierarchical and complex
  models
- **Interactive Prior Elicitation**: Tools for expert knowledge
  integration

## Installation

Install from GitHub:

``` r
devtools::install_github("ikrakib/bayesDiagnostics")
```

Once available on CRAN:

``` r
install.packages("bayesDiagnostics")
```

## Quick Example

``` r
library(bayesDiagnostics)
library(brms)

# Fit Bayesian model
fit <- brm(mpg ~ hp + wt, data = mtcars)

# Conduct prior sensitivity analysis
result <- prior_sensitivity(
  model = fit,
  parameters = c("b_hp", "b_wt"),
  prior_grid = list(
    weak = prior(normal(0, 10), class = b),
    strong = prior(normal(0, 1), class = b)
  )
)

print(result)
plot(result)
```

## Functions by Category

### Category 1: Prior Sensitivity

- `prior_sensitivity()` - Compare posteriors across priors
- `prior_predictive_check()` - Validate prior specifications
- `prior_robustness()` - Test prior hyperparameter sensitivity
- `prior_elicitation_helper()` - Match expert beliefs to distributions

### Category 2: Posterior Predictive Checks

- `automated_ppc()` - Comprehensive PPC battery
- `ppc_crossvalidation()` - K-fold CV with PPCs
- `graphical_ppc()` - Bayesplot-based visualizations
- `bayesian_p_values()` - Test statistics for model checking

### Category 3: Model Comparison

- `model_comparison_suite()` - Multi-method comparison
- `bayes_factor_comparison()` - Bridge sampling for Bayes factors
- `predictive_performance()` - Out-of-sample assessment

### Category 4: Convergence Diagnostics

- `hierarchical_convergence()` - Hierarchical model diagnostics
- `effective_sample_size_diagnostics()` - ESS assessment

### Category 5: Prior Elicitation & Utilities

- `expert_prior_elicitation()` - Interactive prior elicitation
- `prior_simulation()` - Simulate from prior

## Documentation

For detailed documentation, see the package vignettes:

``` r
vignette("bayesDiagnostics")
```

## Contributing

Contributions welcome! Please:

1.  Fork the repository
2.  Create a feature branch
3.  Make your changes
4.  Add tests
5.  Submit a pull request

## Citation

``` r
citation("bayesDiagnostics")
```
