/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.basta;

import dr.evolution.coalescent.IntervalType;
import dr.evolution.tree.Tree;
import dr.evomodel.bigfasttree.BigFastTreeIntervals;
import dr.evomodel.coalescent.basta.ProcessOnCoalescentIntervalDelegate;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Profileable;
import dr.inference.model.Variable;
import dr.util.Citable;
import dr.util.Citation;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.List;

public interface BastaLikelihoodDelegate
extends ProcessOnCoalescentIntervalDelegate,
Model,
Profileable,
Reportable {
    public void makeDirty();

    public void storeState();

    public void restoreState();

    public double calculateLikelihood(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> var1, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> var2, List<Integer> var3, int var4);

    default public void setPartials(int n, double[] dArray) {
        throw new RuntimeException("Not yet implemented");
    }

    default public void getPartials(int n, double[] dArray) {
        if (!1.$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && dArray == null) {
            throw new AssertionError();
        }
        throw new RuntimeException("Not yet implemented");
    }

    default public void updateEigenDecomposition(int n, EigenDecomposition eigenDecomposition, boolean bl) {
        throw new RuntimeException("Not yet implemented");
    }

    default public void updatePopulationSizes(int n, double[] dArray, boolean bl) {
        throw new RuntimeException("Not yet implemented");
    }

    public double[][] calculateGradient(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> var1, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> var2, List<Integer> var3, int var4);

    public double[] calculateGradientPopSize(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> var1, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> var2, List<Integer> var3, int var4);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static abstract class AbstractBastaLikelihoodDelegate
    extends AbstractModel
    implements BastaLikelihoodDelegate,
    Citable {
        protected static final boolean PRINT_COMMANDS = false;
        protected final int maxNumCoalescentIntervals;
        protected final ParallelizationScheme parallelizationScheme;
        protected final int stateCount;
        protected final Tree tree;
        protected final boolean transpose;
        int printCount = 0;

        public AbstractBastaLikelihoodDelegate(String string, Tree tree, int n, boolean bl) {
            super(string);
            this.tree = tree;
            this.stateCount = n;
            this.maxNumCoalescentIntervals = this.getMaxNumberOfCoalescentIntervals(tree);
            this.transpose = bl;
            this.parallelizationScheme = ParallelizationScheme.NONE;
        }

        private int getMaxNumberOfCoalescentIntervals(Tree tree) {
            BigFastTreeIntervals bigFastTreeIntervals = new BigFastTreeIntervals((TreeModel)tree);
            int n = 0;
            for (int i = 0; i < bigFastTreeIntervals.getIntervalCount(); ++i) {
                if (bigFastTreeIntervals.getIntervalType(i) != IntervalType.SAMPLE || bigFastTreeIntervals.getIntervalTime(i) != 0.0) continue;
                ++n;
            }
            return tree.getNodeCount() - n;
        }

        @Override
        public void makeDirty() {
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
            throw new RuntimeException("Should not be called");
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            throw new RuntimeException("Should not be called");
        }

        @Override
        public void storeState() {
        }

        @Override
        public void restoreState() {
        }

        @Override
        protected void acceptState() {
        }

        protected abstract void computeBranchIntervalOperations(List<Integer> var1, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> var2);

        protected abstract void computeTransitionProbabilityOperations(List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> var1);

        protected abstract double computeCoalescentIntervalReduction(List<Integer> var1, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> var2);

        @Override
        public double calculateLikelihood(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list2, List<Integer> list3, int n) {
            this.computeTransitionProbabilityOperations(list2);
            this.computeBranchIntervalOperations(list3, list);
            double d = this.computeCoalescentIntervalReduction(list3, list);
            return d;
        }

        protected abstract void computeBranchIntervalOperationsGrad(List<Integer> var1, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> var2, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> var3);

        protected abstract void computeTransitionProbabilityOperationsGrad(List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> var1);

        protected abstract double[][] computeCoalescentIntervalReductionGrad(List<Integer> var1, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> var2);

        protected abstract double[] computeCoalescentIntervalReductionGradPopSize(List<Integer> var1, List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> var2);

        @Override
        public double[][] calculateGradient(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list2, List<Integer> list3, int n) {
            this.computeTransitionProbabilityOperationsGrad(list2);
            this.computeBranchIntervalOperationsGrad(list3, list2, list);
            double[][] dArray = this.computeCoalescentIntervalReductionGrad(list3, list);
            return dArray;
        }

        @Override
        public double[] calculateGradientPopSize(List<ProcessOnCoalescentIntervalDelegate.BranchIntervalOperation> list, List<ProcessOnCoalescentIntervalDelegate.TransitionMatrixOperation> list2, List<Integer> list3, int n) {
            this.computeBranchIntervalOperationsGrad(list3, list2, list);
            double[] dArray = this.computeCoalescentIntervalReductionGradPopSize(list3, list);
            return dArray;
        }

        abstract String getStamp();

        @Override
        public long getTotalCalculationCount() {
            return 0L;
        }

        @Override
        public Citation.Category getCategory() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public List<Citation> getCitations() {
            return new ArrayList<Citation>();
        }

        @Override
        public String getReport() {
            return null;
        }

        static enum ParallelizationScheme {
            NONE,
            FULL;

        }
    }
}

