/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.io.Importer;
import dr.evolution.io.NexusImporter;
import dr.evolution.io.TreeImporter;
import dr.evolution.tree.Tree;
import dr.evomodel.coalescent.VDdemographicFunction;
import dr.evomodel.coalescent.VariableDemographicModel;
import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.stats.DiscreteStatistics;
import dr.util.HeapSort;
import dr.util.TabularData;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;

@Deprecated
public class EBSPAnalysis
extends TabularData {
    private final double[] xPoints;
    private final double[] means;
    private final double[] medians;
    private final double[][] hpdLower;
    private final double[][] hpdHigh;
    private final double[] HPDLevels;
    private int[] coalBins;
    private final boolean quantiles;
    private final String[] columnNames = new String[]{"time", "mean", "median"};

    public EBSPAnalysis(File file, File[] fileArray, VariableDemographicModel.Type type, String string, String string2, String string3, int n, double d, double[] dArray, boolean bl, boolean bl2, boolean bl3, int n2, PrintWriter printWriter) throws IOException, Importer.ImportException, TraceException {
        int n3;
        int n4;
        int n5;
        int n6;
        double[] dArray2;
        LogFileTraces logFileTraces = new LogFileTraces(file.getCanonicalPath(), file);
        logFileTraces.loadTraces();
        logFileTraces.setBurnIn(0L);
        int n7 = logFileTraces.getStateCount();
        int n8 = (int)Math.floor(d < 1.0 ? (double)n7 * d : d);
        int n9 = n7 - n8;
        logFileTraces.setBurnIn((long)n8 * logFileTraces.getStepSize());
        assert (logFileTraces.getStateCount() == n9);
        this.quantiles = bl;
        if (dArray != null) {
            dArray2 = dArray;
        } else {
            double[] dArray3 = new double[1];
            dArray2 = dArray3;
            dArray3[0] = 0.95;
        }
        this.HPDLevels = dArray2;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        for (int i = 0; i < logFileTraces.getTraceCount(); ++i) {
            String string4 = logFileTraces.getTraceName(i);
            if (string4.equals(string)) {
                n10 = i;
                continue;
            }
            if (string4.equals(string2)) {
                n11 = i;
                continue;
            }
            if (string3 == null || !string4.equals(string3)) continue;
            n12 = i;
        }
        if (n10 < 0 || n11 < 0) {
            throw new TraceException("incorrect trace column names: unable to find populations/indicators");
        }
        double d2 = 0.0;
        if (n > 0) {
            if (n12 < 0) {
                throw new TraceException("incorrect tree height column");
            }
            double d3 = 0.0;
            double[] dArray4 = new double[1];
            for (n6 = 0; n6 < n9; ++n6) {
                logFileTraces.getStateValues(n6, dArray4, n12);
                d3 += dArray4[0];
            }
            d2 = d3 / (double)(n9 * n);
            this.coalBins = new int[n];
            Arrays.fill(this.coalBins, 0);
        }
        TreeImporter[] treeImporterArray = new TreeImporter[fileArray.length];
        boolean bl4 = type == VariableDemographicModel.Type.STEPWISE;
        int n13 = 0;
        for (n6 = 0; n6 < fileArray.length; ++n6) {
            treeImporterArray[n6] = new NexusImporter(new FileReader(fileArray[n6]));
            assert (n8 > 0);
            for (n5 = 0; n5 < n8 - 1; ++n5) {
                treeImporterArray[n6].importNextTree();
            }
            n13 += treeImporterArray[n6].importNextTree().getExternalNodeCount() - 1;
        }
        if (bl4) {
            --n13;
        }
        n6 = n13 + (bl4 ? 1 : 0) + 1;
        this.xPoints = new double[n6];
        Arrays.fill(this.xPoints, 0.0);
        n5 = 0;
        VDdemographicFunction[] vDdemographicFunctionArray = new VDdemographicFunction[n9];
        double[] dArray5 = new double[n13];
        double[] dArray6 = new double[n13 + 1];
        Tree[] treeArray = new Tree[fileArray.length];
        int n14 = 1;
        for (n4 = 0; n4 < n9; ++n4) {
            int n15;
            Object object;
            logFileTraces.getStateValues(n4, dArray5, n11);
            logFileTraces.getStateValues(n4, dArray6, n10);
            if (n14 != 0) {
                for (int i = 0; i < treeArray.length; ++i) {
                    treeArray[i] = treeImporterArray[i].importNextTree();
                    if (treeArray[i] != null) continue;
                    throw new TraceException("All NEXUS tree files should contain the same number of states");
                }
            }
            String string5 = treeArray[0].getId();
            int n16 = Integer.parseInt(string5.substring(string5.indexOf(95) + 1, string5.length()));
            for (int i = 1; i < treeArray.length; ++i) {
                object = treeArray[i].getId();
                n15 = Integer.parseInt(string5.substring(((String)object).indexOf(95) + 1, ((String)object).length()));
                if (n16 == n15) continue;
                throw new TraceException("NEXUS tree files have different rates or corrupted!!!!");
            }
            if ((long)(n4 + n8) * logFileTraces.getStepSize() == (long)n16) {
                n14 = 1;
                VDdemographicFunction vDdemographicFunction = new VDdemographicFunction(treeArray, type, dArray5, dArray6, bl2, bl3);
                if (n2 >= 0 && vDdemographicFunction.numberOfChanges() != n2) continue;
                object = vDdemographicFunction.allTimePoints();
                for (n15 = 0; n15 < ((Object)object).length; ++n15) {
                    int n17 = n15 + 1;
                    this.xPoints[n17] = this.xPoints[n17] + object[n15];
                }
                if (n > 0) {
                    for (Object object2 : object) {
                        int n18 = Math.min((int)(object2 / d2), this.coalBins.length - 1);
                        this.coalBins[n18] = this.coalBins[n18] + 1;
                    }
                }
                vDdemographicFunctionArray[n5] = vDdemographicFunction;
                ++n5;
                vDdemographicFunction.freeze();
                continue;
            }
            n14 = 0;
        }
        n4 = 0;
        while (n4 < this.xPoints.length) {
            int n19 = n4++;
            this.xPoints[n19] = this.xPoints[n19] / (double)n9;
        }
        if (n9 != n5) {
            System.err.println("Different Rates is \"main\" and \"tree\" log files");
        }
        if (n5 < 10) {
            System.err.println("Warning!!! Not Sufficient number of data points");
        }
        dArray5 = new double[n5];
        this.means = new double[n6];
        this.medians = new double[n6];
        this.hpdLower = new double[this.HPDLevels.length][];
        this.hpdHigh = new double[this.HPDLevels.length][];
        for (n3 = 0; n3 < this.HPDLevels.length; ++n3) {
            this.hpdLower[n3] = new double[n6];
            this.hpdHigh[n3] = new double[n6];
        }
        for (n3 = 0; n3 < this.xPoints.length; ++n3) {
            double d4 = this.xPoints[n3];
            for (n4 = 0; n4 < n5; ++n4) {
                dArray5[n4] = vDdemographicFunctionArray[n4].getDemographic(d4);
            }
            int[] nArray = new int[dArray5.length];
            HeapSort.sort(dArray5, nArray);
            this.means[n3] = DiscreteStatistics.mean(dArray5);
            for (int i = 0; i < this.HPDLevels.length; ++i) {
                if (bl) {
                    this.hpdLower[i][n3] = DiscreteStatistics.quantile((1.0 - this.HPDLevels[i]) / 2.0, dArray5, nArray);
                    this.hpdHigh[i][n3] = DiscreteStatistics.quantile((1.0 + this.HPDLevels[i]) / 2.0, dArray5, nArray);
                    continue;
                }
                double[] dArray7 = DiscreteStatistics.HPDInterval(this.HPDLevels[i], dArray5, nArray);
                this.hpdLower[i][n3] = dArray7[0];
                this.hpdHigh[i][n3] = dArray7[1];
            }
            this.medians[n3] = DiscreteStatistics.median(dArray5, nArray);
        }
        if (printWriter != null) {
            for (double d5 : this.xPoints) {
                printWriter.print(d5);
                printWriter.append(' ');
            }
            for (int i = 0; i < n5; ++i) {
                printWriter.println();
                for (double d6 : this.xPoints) {
                    printWriter.print(vDdemographicFunctionArray[i].getDemographic(d6));
                    printWriter.append(' ');
                }
            }
            printWriter.close();
        }
    }

    @Override
    public int nColumns() {
        return this.columnNames.length + 2 * this.HPDLevels.length + (this.coalBins != null ? 1 : 0);
    }

    @Override
    public String columnName(int n) {
        int n2 = this.columnNames.length;
        if (n < n2) {
            return this.columnNames[n];
        }
        if ((n -= n2) < 2 * this.HPDLevels.length) {
            double d = this.HPDLevels[n / 2];
            String string = n % 2 == 0 ? "lower" : "upper";
            return (this.quantiles ? "cpd " : "hpd ") + string + " " + Math.round(d * 100.0);
        }
        assert (n - 2 * this.HPDLevels.length == 0);
        return "bins";
    }

    @Override
    public int nRows() {
        return Math.max(this.xPoints.length, this.coalBins != null ? this.coalBins.length : 0);
    }

    @Override
    public Object data(int n, int n2) {
        switch (n2) {
            case 0: {
                if (n >= this.xPoints.length) break;
                return this.xPoints[n];
            }
            case 1: {
                if (n >= this.means.length) break;
                return this.means[n];
            }
            case 2: {
                if (n >= this.medians.length) break;
                return this.medians[n];
            }
            default: {
                int n3 = n2 - this.columnNames.length;
                if (n3 < 2 * this.HPDLevels.length) {
                    int n4;
                    if (n >= this.xPoints.length || 0 > (n4 = n3 / 2) || n4 >= this.HPDLevels.length) break;
                    if (n3 % 2 == 0) {
                        return this.hpdLower[n4][n];
                    }
                    return this.hpdHigh[n4][n];
                }
                if (n >= this.coalBins.length) break;
                return this.coalBins[n];
            }
        }
        return "";
    }
}

