## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(scenfire)

## ----parallel-example---------------------------------------------------------
# Dummy data for demonstration (replace with your actual data)
set.seed(123)
historical_data_for_target <- floor(fit_powerlaw(n = 500, alpha = 2, xmin = 10, xmax = 10000))
event_surfaces <- fit_powerlaw(n = 10000, alpha = 2, xmin = 10, xmax = 10000)
# Discard simulated fires that are too large (below 110% max historical size)
event_surfaces <- event_surfaces[event_surfaces<max(historical_data_for_target)*1.1]
event_probabilities <- rnorm(length(event_surfaces))
event_probabilities <- (event_probabilities-min(event_probabilities))/
                        (max(event_probabilities)-min(event_probabilities))

y <- 100 #number of years spanning historical fire data
check_fire_data(fires_hist_size = historical_data_for_target,
                sim_perimeters_size = event_surfaces,
                n_years = y)

reference_surface_example <- sum(historical_data_for_target)/y
surface_threshold_example <- check_fire_data(fires_hist_size = historical_data_for_target,
                                             sim_perimeters_size = event_surfaces,
                                             n_years = 10)
tolerance_example <- 0.1

# Create a dummy target histogram (assuming 'event_surfaces' from historical data)
# For a real scenario, 'event_surfaces' here would be your historical fire sizes.

target_info_example <- build_target_hist(num_bins = 10, logaritmic = TRUE,
                                         sizes = historical_data_for_target,
                                         event_surfaces = event_surfaces)
target_hist <- target_info_example$target_hist
bins <- target_info_example$bins

foreach::registerDoSEQ()

# Run the selection process
selected_events_result <- select_events(
  event_sizes = event_surfaces,
  event_probabilities = event_probabilities,
  target_hist = target_hist,
  bins = bins,
  reference_surface = reference_surface_example,
  surface_threshold = surface_threshold_example,
  tolerance = tolerance_example,
  max_it = 2 # Reduced iterations for example
)

# Stop the parallel cluster when done
doParallel::stopImplicitCluster()

