/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static void minimize(Automaton automaton) {
        if (!automaton.isSingleton()) {
            switch (Automaton.minimization) {
                case 0: {
                    MinimizationOperations.minimizeHuffman(automaton);
                    break;
                }
                case 1: {
                    MinimizationOperations.minimizeBrzozowski(automaton);
                    break;
                }
                default: {
                    MinimizationOperations.minimizeHopcroft(automaton);
                }
            }
        }
        automaton.hash_code = automaton.getNumberOfStates() * 3 + automaton.getNumberOfTransitions() * 2;
        if (automaton.hash_code == 0) {
            automaton.hash_code = 1;
        }
    }

    private static boolean statesAgree(Transition[][] transitionArray, boolean[][] blArray, int n, int n2) {
        Transition[] transitionArray2 = transitionArray[n];
        Transition[] transitionArray3 = transitionArray[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < transitionArray2.length && n4 < transitionArray3.length) {
            if (transitionArray2[n3].max < transitionArray3[n4].min) {
                ++n3;
                continue;
            }
            if (transitionArray3[n4].max < transitionArray2[n3].min) {
                ++n4;
                continue;
            }
            int n5 = transitionArray2[n3].to.number;
            int n6 = transitionArray3[n4].to.number;
            if (n5 > n6) {
                int n7 = n5;
                n5 = n6;
                n6 = n7;
            }
            if (blArray[n5][n6]) {
                return false;
            }
            if (transitionArray2[n3].max < transitionArray3[n4].max) {
                ++n3;
                continue;
            }
            ++n4;
        }
        return true;
    }

    private static void addTriggers(Transition[][] transitionArray, ArrayList<ArrayList<HashSet<IntPair>>> arrayList, int n, int n2) {
        Transition[] transitionArray2 = transitionArray[n];
        Transition[] transitionArray3 = transitionArray[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < transitionArray2.length && n4 < transitionArray3.length) {
            if (transitionArray2[n3].max < transitionArray3[n4].min) {
                ++n3;
                continue;
            }
            if (transitionArray3[n4].max < transitionArray2[n3].min) {
                ++n4;
                continue;
            }
            if (transitionArray2[n3].to != transitionArray3[n4].to) {
                int n5 = transitionArray2[n3].to.number;
                int n6 = transitionArray3[n4].to.number;
                if (n5 > n6) {
                    int n7 = n5;
                    n5 = n6;
                    n6 = n7;
                }
                if (arrayList.get(n5).get(n6) == null) {
                    arrayList.get(n5).set(n6, new HashSet());
                }
                arrayList.get(n5).get(n6).add(new IntPair(n, n2));
            }
            if (transitionArray2[n3].max < transitionArray3[n4].max) {
                ++n3;
                continue;
            }
            ++n4;
        }
    }

    private static void markPair(boolean[][] blArray, ArrayList<ArrayList<HashSet<IntPair>>> arrayList, int n, int n2) {
        blArray[n][n2] = true;
        if (arrayList.get(n).get(n2) != null) {
            for (IntPair intPair : arrayList.get(n).get(n2)) {
                int n3 = intPair.n1;
                int n4 = intPair.n2;
                if (n3 > n4) {
                    int n5 = n3;
                    n3 = n4;
                    n4 = n5;
                }
                if (blArray[n3][n4]) continue;
                MinimizationOperations.markPair(blArray, arrayList, n3, n4);
            }
        }
    }

    private static <T> void initialize(ArrayList<T> arrayList, int n) {
        for (int i = 0; i < n; ++i) {
            arrayList.add(null);
        }
    }

    public static void minimizeHuffman(Automaton automaton) {
        int n;
        int n2;
        int n3;
        automaton.determinize();
        automaton.totalize();
        Set<State> set = automaton.getStates();
        Transition[][] transitionArray = new Transition[set.size()][];
        State[] stateArray = set.toArray(new State[set.size()]);
        boolean[][] blArray = new boolean[stateArray.length][stateArray.length];
        ArrayList<ArrayList<HashSet<IntPair>>> arrayList = new ArrayList<ArrayList<HashSet<IntPair>>>();
        for (n3 = 0; n3 < stateArray.length; ++n3) {
            ArrayList arrayList2 = new ArrayList();
            MinimizationOperations.initialize(arrayList2, stateArray.length);
            arrayList.add(arrayList2);
        }
        for (n3 = 0; n3 < stateArray.length; ++n3) {
            stateArray[n3].number = n3;
            transitionArray[n3] = stateArray[n3].getSortedTransitionArray(false);
            for (int i = n3 + 1; i < stateArray.length; ++i) {
                if (stateArray[n3].accept == stateArray[i].accept) continue;
                blArray[n3][i] = true;
            }
        }
        for (n3 = 0; n3 < stateArray.length; ++n3) {
            for (int i = n3 + 1; i < stateArray.length; ++i) {
                if (blArray[n3][i]) continue;
                if (MinimizationOperations.statesAgree(transitionArray, blArray, n3, i)) {
                    MinimizationOperations.addTriggers(transitionArray, arrayList, n3, i);
                    continue;
                }
                MinimizationOperations.markPair(blArray, arrayList, n3, i);
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < stateArray.length; ++n2) {
            stateArray[n2].number = -1;
        }
        for (n2 = 0; n2 < stateArray.length; ++n2) {
            if (stateArray[n2].number != -1) continue;
            stateArray[n2].number = n3;
            for (n = n2 + 1; n < stateArray.length; ++n) {
                if (blArray[n2][n]) continue;
                stateArray[n].number = n3;
            }
            ++n3;
        }
        State[] stateArray2 = new State[n3];
        for (n = 0; n < n3; ++n) {
            stateArray2[n] = new State();
        }
        for (n = 0; n < stateArray.length; ++n) {
            stateArray2[stateArray[n].number].number = n;
            if (stateArray[n] != automaton.initial) continue;
            automaton.initial = stateArray2[stateArray[n].number];
        }
        for (n = 0; n < n3; ++n) {
            State state = stateArray2[n];
            state.accept = stateArray[state.number].accept;
            for (Transition transition : stateArray[state.number].transitions) {
                state.transitions.add(new Transition(transition.min, transition.max, stateArray2[transition.to.number]));
            }
        }
        automaton.removeDeadTransitions();
    }

    public static void minimizeBrzozowski(Automaton automaton) {
        if (automaton.isSingleton()) {
            return;
        }
        BasicOperations.determinize(automaton, SpecialOperations.reverse(automaton));
        BasicOperations.determinize(automaton, SpecialOperations.reverse(automaton));
    }

    public static void minimizeHopcroft(Automaton automaton) {
        int n;
        int n2;
        int n3;
        ArrayList arrayList;
        Serializable serializable;
        Object object;
        automaton.determinize();
        Set<Transition> set = automaton.initial.getTransitions();
        if (set.size() == 1) {
            object = set.iterator().next();
            if (((Transition)object).to == automaton.initial && ((Transition)object).min == '\u0000' && ((Transition)object).max == '\uffff') {
                return;
            }
        }
        automaton.totalize();
        object = automaton.getStates();
        State[] stateArray = new State[object.size()];
        int n4 = 0;
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            serializable = (State)object2.next();
            stateArray[n4] = serializable;
            ((State)serializable).number = n4++;
        }
        object2 = automaton.getStartPoints();
        serializable = new ArrayList();
        for (int i = 0; i < stateArray.length; ++i) {
            arrayList = new ArrayList();
            MinimizationOperations.initialize(arrayList, ((Object)object2).length);
            ((ArrayList)serializable).add(arrayList);
        }
        boolean[][] blArray = new boolean[stateArray.length][((Object)object2).length];
        arrayList = new ArrayList();
        MinimizationOperations.initialize(arrayList, stateArray.length);
        int[] nArray = new int[stateArray.length];
        StateList[][] stateListArray = new StateList[stateArray.length][((Object)object2).length];
        StateListNode[][] stateListNodeArray = new StateListNode[stateArray.length][((Object)object2).length];
        LinkedList<IntPair> linkedList = new LinkedList<IntPair>();
        boolean[][] blArray2 = new boolean[((Object)object2).length][stateArray.length];
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean[] blArray3 = new boolean[stateArray.length];
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        boolean[] blArray4 = new boolean[stateArray.length];
        ArrayList arrayList4 = new ArrayList();
        MinimizationOperations.initialize(arrayList4, stateArray.length);
        for (n3 = 0; n3 < stateArray.length; ++n3) {
            arrayList4.set(n3, new ArrayList());
            arrayList.set(n3, new LinkedList());
            for (int i = 0; i < ((Object)object2).length; ++i) {
                ((ArrayList)((ArrayList)serializable).get(n3)).set(i, new LinkedList());
                stateListArray[n3][i] = new StateList();
            }
        }
        for (n3 = 0; n3 < stateArray.length; ++n3) {
            State state = stateArray[n3];
            int n5 = state.accept ? 0 : 1;
            ((LinkedList)arrayList.get(n5)).add(state);
            nArray[state.number] = n5;
            for (int i = 0; i < ((Object)object2).length; ++i) {
                Object object3 = object2[i];
                State state2 = state.step((char)object3);
                ((LinkedList)((ArrayList)((ArrayList)serializable).get(state2.number)).get(i)).add(state);
                blArray[state2.number][i] = true;
            }
        }
        for (n3 = 0; n3 <= 1; ++n3) {
            for (int i = 0; i < ((Object)object2).length; ++i) {
                for (State state : (LinkedList)arrayList.get(n3)) {
                    if (!blArray[state.number][i]) continue;
                    stateListNodeArray[state.number][i] = stateListArray[n3][i].add(state);
                }
            }
        }
        for (n3 = 0; n3 < ((Object)object2).length; ++n3) {
            int n6 = stateListArray[0][n3].size;
            int n7 = stateListArray[1][n3].size;
            n2 = n6 <= n7 ? 0 : 1;
            linkedList.add(new IntPair(n2, n3));
            blArray2[n3][n2] = true;
        }
        n3 = 2;
        while (!linkedList.isEmpty()) {
            IntPair intPair = (IntPair)linkedList.removeFirst();
            int n8 = intPair.n1;
            n2 = intPair.n2;
            blArray2[n2][n8] = false;
            Object object4 = stateListArray[n8][n2].first;
            while (object4 != null) {
                for (Object object5 : (LinkedList)((ArrayList)((ArrayList)serializable).get(((StateListNode)object4).q.number)).get(n2)) {
                    if (blArray3[((State)object5).number]) continue;
                    blArray3[((State)object5).number] = true;
                    arrayList2.add(object5);
                    int n9 = nArray[((State)object5).number];
                    ((ArrayList)arrayList4.get(n9)).add(object5);
                    if (blArray4[n9]) continue;
                    blArray4[n9] = true;
                    arrayList3.add(n9);
                }
                object4 = ((StateListNode)object4).next;
            }
            object4 = arrayList3.iterator();
            while (object4.hasNext()) {
                Object object5;
                int n10 = (Integer)object4.next();
                if (((ArrayList)arrayList4.get(n10)).size() < ((LinkedList)arrayList.get(n10)).size()) {
                    int n11;
                    object5 = (LinkedList)arrayList.get(n10);
                    LinkedList linkedList2 = (LinkedList)arrayList.get(n3);
                    for (State state : (ArrayList)arrayList4.get(n10)) {
                        ((LinkedList)object5).remove(state);
                        linkedList2.add(state);
                        nArray[state.number] = n3;
                        for (n11 = 0; n11 < ((Object)object2).length; ++n11) {
                            StateListNode stateListNode = stateListNodeArray[state.number][n11];
                            if (stateListNode == null || stateListNode.sl != stateListArray[n10][n11]) continue;
                            stateListNode.remove();
                            stateListNodeArray[state.number][n11] = stateListArray[n3][n11].add(state);
                        }
                    }
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        int n12 = stateListArray[n10][i].size;
                        n11 = stateListArray[n3][i].size;
                        if (!blArray2[i][n10] && 0 < n12 && n12 <= n11) {
                            blArray2[i][n10] = true;
                            linkedList.add(new IntPair(n10, i));
                            continue;
                        }
                        blArray2[i][n3] = true;
                        linkedList.add(new IntPair(n3, i));
                    }
                    ++n3;
                }
                object5 = ((ArrayList)arrayList4.get(n10)).iterator();
                while (object5.hasNext()) {
                    State state = (State)object5.next();
                    blArray3[state.number] = false;
                }
                blArray4[n10] = false;
                ((ArrayList)arrayList4.get(n10)).clear();
            }
            arrayList2.clear();
            arrayList3.clear();
        }
        State[] stateArray2 = new State[n3];
        for (n = 0; n < stateArray2.length; ++n) {
            State state;
            stateArray2[n] = state = new State();
            for (State state3 : (LinkedList)arrayList.get(n)) {
                if (state3 == automaton.initial) {
                    automaton.initial = state;
                }
                state.accept = state3.accept;
                state.number = state3.number;
                state3.number = n;
            }
        }
        for (n = 0; n < stateArray2.length; ++n) {
            State state = stateArray2[n];
            state.accept = stateArray[state.number].accept;
            for (Transition transition : stateArray[state.number].transitions) {
                state.transitions.add(new Transition(transition.min, transition.max, stateArray2[transition.to.number]));
            }
        }
        automaton.removeDeadTransitions();
    }

    static class StateListNode {
        State q;
        StateListNode next;
        StateListNode prev;
        StateList sl;

        StateListNode(State state, StateList stateList) {
            this.q = state;
            this.sl = stateList;
            if (stateList.size++ == 0) {
                stateList.first = stateList.last = this;
            } else {
                stateList.last.next = this;
                this.prev = stateList.last;
                stateList.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }

    static class StateList {
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(State state) {
            return new StateListNode(state, this);
        }
    }

    static class IntPair {
        int n1;
        int n2;

        IntPair(int n, int n2) {
            this.n1 = n;
            this.n2 = n2;
        }
    }
}

