/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;

public final class AtMostNValue
extends AbstractLargeIntSConstraint {
    private final BitSet gval;
    private int nGval;
    private final TIntArrayList freeVars;
    private TIntArrayList dVar;
    private final BitSet[] ngraph;
    private final int maxDSize;
    private final int nVars;
    private final int offset;

    private static IntDomainVar[] makeVarTable(IntDomainVar[] vars, IntDomainVar nvalue) {
        IntDomainVar[] vs = new IntDomainVar[vars.length + 1];
        System.arraycopy(vars, 0, vs, 0, vars.length);
        vs[vars.length] = nvalue;
        return vs;
    }

    public AtMostNValue(IntDomainVar[] vars, IntDomainVar nvalue) {
        super(ConstraintEvent.QUADRATIC, AtMostNValue.makeVarTable(vars, nvalue));
        int toffset = Integer.MAX_VALUE;
        int tsize = 0;
        for (IntDomainVar v : vars) {
            if (toffset > v.getInf()) {
                toffset = v.getInf();
            }
            if (tsize <= v.getSup() - v.getInf() + 1) continue;
            tsize = v.getSup() - v.getInf() + 1;
        }
        this.offset = -toffset;
        this.maxDSize = tsize;
        this.gval = new BitSet(tsize);
        this.dVar = new TIntArrayList(vars.length);
        this.freeVars = new TIntArrayList(vars.length);
        this.ngraph = new BitSet[vars.length];
        for (int i = 0; i < this.ngraph.length; ++i) {
            this.ngraph[i] = new BitSet(vars.length);
        }
        this.nVars = vars.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restrict(IntDomainVar v, BitSet allowvalues) throws ContradictionException {
        int toffset = v.getInf();
        BitSet allowedDomain = allowvalues.get(v.getInf() + this.offset, v.getSup() + this.offset + 1);
        int newInf = allowedDomain.nextSetBit(0) + toffset;
        int newSup = allowedDomain.length() + toffset;
        v.updateInf(newInf, this, true);
        v.updateSup(newSup, this, true);
        if (v.hasEnumeratedDomain()) {
            IntDomain dom = v.getDomain();
            DisposableIntIterator it = dom.getIterator();
            try {
                while (it.hasNext()) {
                    int val = it.next();
                    if (allowedDomain.get(val - toffset)) continue;
                    v.removeVal(val, this, true);
                }
            }
            finally {
                it.dispose();
            }
        }
    }

    boolean emptyIntersectionWithGval(IntDomainVar v) {
        DisposableIntIterator vdom = v.getDomain().getIterator();
        while (vdom.hasNext()) {
            if (!this.gval.get(vdom.next() + this.offset)) continue;
            vdom.dispose();
            return false;
        }
        vdom.dispose();
        return true;
    }

    BitSet intersectionDomains() {
        if (!this.dVar.isEmpty()) {
            LinkedList<Integer> inter = new LinkedList<Integer>();
            DisposableIntIterator vdom = ((IntDomainVar[])this.vars)[this.dVar.get(0)].getDomain().getIterator();
            while (vdom.hasNext()) {
                inter.add(vdom.next());
            }
            vdom.dispose();
            for (int i = 0; i < this.dVar.size(); ++i) {
                int next = this.dVar.get(i);
                IntDomainVar v = ((IntDomainVar[])this.vars)[next];
                Iterator it = inter.iterator();
                while (it.hasNext()) {
                    if (v.canBeInstantiatedTo((Integer)it.next())) continue;
                    it.remove();
                }
            }
            BitSet interDvar = new BitSet(this.maxDSize);
            for (Integer i : inter) {
                interDvar.set(i + this.offset);
            }
            return interDvar;
        }
        return new BitSet(0);
    }

    boolean basicPruning() throws ContradictionException {
        this.nGval = 0;
        this.gval.clear();
        this.dVar.clear();
        this.freeVars.clear();
        for (int i = 0; i < this.nVars; ++i) {
            IntDomainVar v = ((IntDomainVar[])this.vars)[i];
            if (v.isInstantiated()) {
                if (!this.gval.get(v.getVal() + this.offset)) {
                    ++this.nGval;
                }
                this.gval.set(v.getVal() + this.offset);
                continue;
            }
            this.freeVars.add(i);
        }
        ((IntDomainVar[])this.vars)[this.nVars].updateInf(this.nGval, this, false);
        int k = ((IntDomainVar[])this.vars)[((IntDomainVar[])this.vars).length - 1].getSup() - this.nGval;
        if (k == 0) {
            this.pruningK0();
            return false;
        }
        if (this.nGval == 0) {
            this.dVar = (TIntArrayList)this.freeVars.clone();
        } else {
            for (int i = 0; i < this.freeVars.size(); ++i) {
                int j = this.freeVars.get(i);
                if (!this.emptyIntersectionWithGval(((IntDomainVar[])this.vars)[j])) continue;
                this.dVar.add(j);
            }
        }
        if (k == 1) {
            if (!this.dVar.isEmpty()) {
                this.pruningK1();
            }
            return false;
        }
        return true;
    }

    void pruningK0() throws ContradictionException {
        for (int k = 0; k < this.freeVars.size(); ++k) {
            int i = this.freeVars.get(k);
            this.restrict(((IntDomainVar[])this.vars)[i], this.gval);
        }
    }

    void pruningK1() throws ContradictionException {
        BitSet interDvar = this.intersectionDomains();
        interDvar.or(this.gval);
        for (int k = 0; k < this.freeVars.size(); ++k) {
            int i = this.freeVars.get(k);
            this.restrict(((IntDomainVar[])this.vars)[i], interDvar);
        }
    }

    void mdPruning() throws ContradictionException {
        if (this.basicPruning() && this.nGval + this.dVar.size() >= ((IntDomainVar[])this.vars)[this.nVars].getSup()) {
            LinkedList<IntDomainVar> a = new LinkedList<IntDomainVar>();
            this.computeNeighborsGraph();
            while (!this.dVar.isEmpty()) {
                int next;
                int i;
                int min = Integer.MAX_VALUE;
                int y = -1;
                for (i = 0; i < this.dVar.size(); ++i) {
                    next = this.dVar.get(i);
                    if (min < this.ngraph[next].size()) continue;
                    min = this.ngraph[next].size();
                    y = next;
                }
                for (i = 0; i < this.dVar.size(); ++i) {
                    next = this.dVar.get(i);
                    if (next != y && !this.ngraph[y].get(next)) continue;
                    this.dVar.remove(i--);
                }
                a.add(((IntDomainVar[])this.vars)[y]);
            }
            int lb = a.size() + this.nGval;
            ((IntDomainVar[])this.vars)[this.nVars].updateInf(lb, this, false);
            if (lb == ((IntDomainVar[])this.vars)[this.nVars].getSup()) {
                this.pruning(a);
            }
        }
    }

    void computeNeighborsGraph() {
        int i;
        for (i = 0; i < this.ngraph.length; ++i) {
            this.ngraph[i].clear();
        }
        for (i = 0; i < this.dVar.size(); ++i) {
            int y;
            int x = this.dVar.get(i);
            int j = 0;
            while (i < this.dVar.size() && x > (y = this.dVar.get(j))) {
                if (((IntDomainVar[])this.vars)[x].canBeEqualTo(((IntDomainVar[])this.vars)[y])) {
                    this.ngraph[x].set(y);
                    this.ngraph[y].set(x);
                }
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pruning(LinkedList<IntDomainVar> a) throws ContradictionException {
        BitSet unionOfAllowedValue = this.gval;
        for (IntDomainVar x : a) {
            DisposableIntIterator it = x.getDomain().getIterator();
            try {
                while (it.hasNext()) {
                    int value = it.next();
                    unionOfAllowedValue.set(value + this.offset);
                }
            }
            finally {
                it.dispose();
            }
        }
        for (int k = 0; k < this.freeVars.size(); ++k) {
            int i = this.freeVars.get(k);
            this.restrict(((IntDomainVar[])this.vars)[i], unionOfAllowedValue);
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.mdPruning();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        BitSet b = new BitSet(this.nVars);
        int nval = 0;
        for (int i = 0; i < this.nVars; ++i) {
            int val = tuple[i];
            if (b.get(val)) continue;
            ++nval;
            b.set(val);
        }
        return nval <= tuple[this.nVars];
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder(17);
        sb.append("AtMostNValue({");
        for (int i = 0; i < ((IntDomainVar[])this.vars).length - 1; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = ((IntDomainVar[])this.vars)[i];
            sb.append(var.pretty());
        }
        sb.append("}, ").append(((IntDomainVar[])this.vars)[((IntDomainVar[])this.vars).length - 1]).append(')');
        return sb.toString();
    }
}

