/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.support_vector_machine;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.support_vector_machine.Kernel;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name="PolynomialKernelType", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="PolynomialKernelType")
@JsonPropertyOrder(value={"description", "gamma", "coef0", "degree", "extensions"})
public class PolynomialKernel
extends Kernel
implements HasExtensions<PolynomialKernel> {
    @XmlAttribute(name="description")
    @JsonProperty(value="description")
    private String description;
    @XmlAttribute(name="gamma")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="gamma")
    private Number gamma;
    @XmlAttribute(name="coef0")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="coef0")
    private Number coef0;
    @XmlAttribute(name="degree")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="degree")
    private Number degree;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final Number DEFAULT_GAMMA = new RealNumberAdapter().unmarshal("1");
    private static final Number DEFAULT_COEF0 = new RealNumberAdapter().unmarshal("1");
    private static final Number DEFAULT_DEGREE = new RealNumberAdapter().unmarshal("1");
    private static final long serialVersionUID = 67371275L;

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public PolynomialKernel setDescription(@Property(value="description") String description) {
        this.description = description;
        return this;
    }

    public Number getGamma() {
        if (this.gamma == null) {
            return DEFAULT_GAMMA;
        }
        return this.gamma;
    }

    public PolynomialKernel setGamma(@Property(value="gamma") Number gamma) {
        this.gamma = gamma;
        return this;
    }

    public Number getCoef0() {
        if (this.coef0 == null) {
            return DEFAULT_COEF0;
        }
        return this.coef0;
    }

    public PolynomialKernel setCoef0(@Property(value="coef0") Number coef0) {
        this.coef0 = coef0;
        return this;
    }

    public Number getDegree() {
        if (this.degree == null) {
            return DEFAULT_DEGREE;
        }
        return this.degree;
    }

    public PolynomialKernel setDegree(@Property(value="degree") Number degree) {
        this.degree = degree;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PolynomialKernel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

