% Generated by roxygen2: do not edit by hand
\name{rep}
\alias{rep}
\title{Replicate Elements of Vectors/Lists}
\arguments{
  \item{x}{a vector/list}
  \item{each}{number of times to repeat each element of x}
  \item{times}{number of times to repeat x}
  \item{length.out}{desired length of output (repeats x)
}
}

\details{
Replicating elements of 1, 2, ..., 10
\code{
rep(1:10, times = 2)
rep(1:10, each = 2)
rep(1:10, length.out = 20)
}

x doesn't have to fit nicely into length.out
\code{
rep(1:10, length.out = 17)
}

times can also be a vector
\code{
rep(1:10, times = 1:10)
}

Can also replicate elements of lists
\code{
rep(list(1, 2, 3), times = 2)
rep(list(1, 2, 3), each = 2)
rep(list(1, 2, 3), length.out = 6)
}}

