## ----eval=FALSE---------------------------------------------------------------
# install.packages("sparsevar", repos = "http://cran.us.r-project.org")

## ----eval=FALSE---------------------------------------------------------------
# install.packages("devtools", repos = "http://cran.us.r-project.org")
# devtools::install_github("svazzole/sparsevar")

## -----------------------------------------------------------------------------
library(sparsevar)

## ----cache = TRUE-------------------------------------------------------------
set.seed(1)
sim <- simulate_var(n = 20, p = 2)

## ----cache = TRUE-------------------------------------------------------------
fit <- fit_var(sim$series, p = 2)
fit_2 <- fit_var(sim$series, p = 2, threshold = TRUE)

## ----warning=FALSE------------------------------------------------------------
plot_var(sim, fit, fit_2)

## ----eval=FALSE---------------------------------------------------------------
# irf <- impulse_response(fit)
# eb <- error_bands_irf(fit, irf)

## ----eval=FALSE---------------------------------------------------------------
# results <- fit_var(rets)

## ----eval=FALSE---------------------------------------------------------------
# results <- fit_var(rets, p = 3, penalty = "ENET", parallel = TRUE,
#                    ncores = 5, alpha = 0.95, type.measure = "mae",
#                    lambda = "lambda.1se")

## ----eval = TRUE--------------------------------------------------------------
irf_2 <- impulse_response(fit_2)
eb_2 <- error_bands_irf(fit_2, irf_2, verbose = FALSE)
plot_irf_grid(irf_2, eb_2, indexes = c(2, 3, 4, 11))

## ----eval=FALSE---------------------------------------------------------------
# sim <- simulate_var(n = 100, nobs = 250, rho = 0.75,
#                     sparsity = 0.05, method = "normal")

